import 'package:account_center/style/style_params.dart';
import 'package:flutter/material.dart';

class RadioCheck extends StatelessWidget {
  final String title;
  final dynamic value;
  final dynamic groupValue;
  final Function(dynamic)? change;
  final bool isForbid;
  const RadioCheck(
      {Key? key,
      required this.title,
      this.value,
      this.groupValue,
      this.change,
      this.isForbid = false})
      : super(key: key);

  @override
  Widget build(BuildContext context) {
    return InkWell(
      onTap: () {
        change?.call(value);
      },
      child: Container(
        padding: EdgeInsets.only(top: 2, bottom: 2, right: 4),
        alignment: Alignment.centerLeft,
        child: Row(
          mainAxisSize: MainAxisSize.min,
          children: [
            Container(
              width: 14,
              height: 14,
              decoration: BoxDecoration(
                borderRadius: BorderRadius.circular(10),
                border: Border.all(color: getColor(), width: checked() ? 4 : 1),
              ),
            ),
            SizedBox(
              width: 6,
            ),
            Text(
              title,
              style: TextStyle(
                  fontSize: 16,
                  color: Color(0xFF344254),
                  fontWeight: FontWeight.w500),
            )
          ],
        ),
      ),
    );
  }

  bool checked() {
    return value == groupValue;
  }

  Color getColor() {
    if (isForbid) {
      return Color(0xFFDCDFE6);
    } else if (checked()) {
      return StyleParams.themeColor;
    } else {
      return Color(0xFFDCDFE6);
    }
  }
}
