import 'dart:io';

import 'package:account_center/common/android_version_util.dart';
import 'package:permission_handler/permission_handler.dart';

export 'package:permission_handler/permission_handler.dart';

abstract class PermissionUtil {
  /// 申请权限
  /// 授予权限返回true， 否则返回false
  static Future<bool> requestPermission(Permission permission) async {
    //获取当前的权限
    var status = await permission.status;
    if (status == PermissionStatus.granted ||
        status == PermissionStatus.limited) {
      //已经授权
      return true;
    } else {
      //未授权则发起一次申请
      status = await permission.request();
      if (status == PermissionStatus.granted ||
          status == PermissionStatus.limited) {
        return true;
      } else {
        return false;
      }
    }
  }

  /// android 10之前 存储权限
  static Future<bool> checkStorePermission() async {
    if (Platform.isAndroid) {
      if (isAndroidVersionBelow10()) {
        return await Permission.storage.request().isGranted;
      } else {
        return true;
      }
    } else {
      return true;
    }
  }
}
