import 'package:flutter/material.dart';

///   无appbar的scaffold
class NoAppBarScaffold extends StatelessWidget {
  final Widget child;
  final double heightBG;
  final Widget? drawer;

  //渐变色背景
  final List<Color>? colors;

  //背景图片URL
  final String? imageUrl;
  final GlobalKey<ScaffoldState>? drawerKey;
  final Widget? bottomButton;

  const NoAppBarScaffold(
      {Key? key,
      required this.child,
      this.colors,
      this.imageUrl,
      this.heightBG = 266.0,
      this.drawer,
      this.drawerKey,
      this.bottomButton})
      : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      key: drawerKey,
      drawer: drawer,
      body: Stack(
        children: [
          Container(
            height: heightBG,
            width: double.infinity,
            decoration: BoxDecoration(
              gradient: LinearGradient(
                begin: Alignment.topCenter,
                end: Alignment.bottomCenter,
                colors: colors ??
                    [
                      Color(0xFF3781E4),
                      Color(0x598CBFFE),
                    ],
              ),
            ),
            child: imageUrl != null
                ? Image.network(
                    imageUrl!,
                    fit: BoxFit.cover,
                  )
                : null,
          ),
          SafeArea(child: child),
        ],
      ),
      bottomNavigationBar: bottomButton,
    );
  }
}
