import 'package:account_center/widget/form/form_row.dart';
import 'package:flutter/material.dart';

/// 表单输入框展示
class FormShow extends StatelessWidget {
  final String title;
  final String? content;

  const FormShow({
    Key? key,
    required this.title,
    required this.content,
  }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return FormRow(
      title: title,
      isRequired: false,
      crossAxisAlignment: CrossAxisAlignment.start,
      child: Text(
        content ?? '',
        style: TextStyle(
            color: Color(0xff344254),
            fontSize: 16,
            fontWeight: FontWeight.w500),
      ),
    );
  }
}
