import 'package:account_center/account_center.dart';
import 'package:account_center/common/utils/image_load.dart';
import 'package:account_center/page/account_company/company_auth/widget/common/gesture_tap.dart';
import 'package:account_center/widget/asset_image_widget.dart';
import 'package:flutter/material.dart';

class CertificateSelect extends StatelessWidget {
  final String title;
  final String secondTitle;
  final String url;
  final String? bagUrl;
  final Function()? onTap;
  final Function()? onDelete;
  final bool? license;

  const CertificateSelect({
    Key? key,
    required this.title,
    required this.secondTitle,
    required this.url,
    this.bagUrl,
    this.onTap,
    this.onDelete,
    this.license,
  }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    double borderSize = 10;
    return Container(
      color: Colors.white,
      child: Container(
        height: license == true ? 240 : 150,
        margin: EdgeInsets.only(left: 15, right: 15, bottom: 20),
        padding: EdgeInsets.all(10),
        decoration: BoxDecoration(
          borderRadius: BorderRadius.circular(5),
          color: Color(0xffF3F6FA),
        ),
        child: Row(
          mainAxisAlignment: MainAxisAlignment.spaceEvenly,
          children: [
            hGap15,
            Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              mainAxisAlignment: MainAxisAlignment.center,
              children: [
                Text(
                  title,
                  style: TextStyle(fontSize: 16, fontWeight: FontWeight.bold),
                ),
                vGap5,
                Text(
                  secondTitle,
                  style: TextStyle(fontSize: 12, color: Color(0xff666666)),
                )
              ],
            ),
            hGap10,
            Expanded(
              child: InkWell(
                onTap: onTap,
                child: Stack(
                  alignment: Alignment.center,
                  children: [
                    // AssetImageWidget(
                    //   imgFileName:
                    //       license == true ? 'license_border' : 'ic_id_border',
                    //   width: license == true ? 190 : 170,
                    // ),
                    _dashBorder(
                      borderSize,
                      width: license == true ? 190 : 174,
                      height: license == true ? 214 : 92,
                    ),
                    Visibility(
                      visible: url.isEmpty,
                      child: AssetImageWidget(
                        imgFileName: bagUrl ?? '',
                        height: license == true ? 210 : 90,
                      ),
                    ),
                    Visibility(
                      visible: url.isNotEmpty,
                      child: Stack(
                        children: [
                          license == true
                              ? ImageLoad.licenseBusiness(url)
                              : ImageLoad.idCard(url),
                          Positioned(
                            top: 0,
                            right: 0,
                            child: GestureTapWidget(
                              onTap: onDelete,
                              child: Container(
                                decoration: BoxDecoration(
                                    color: Colors.white,
                                    borderRadius: BorderRadius.circular(20)),
                                child: Icon(
                                  Icons.cancel_rounded,
                                  color: Colors.red,
                                ),
                              ),
                            ),
                          )
                        ],
                      ),
                    ),
                  ],
                ),
              ),
            )
          ],
        ),
      ),
    );
  }

  Container _dashBorder(double borderSize,
      {double width = 172, double height = 92}) {
    return Container(
      width: width,
      height: height,
      alignment: Alignment.center,
      child: Stack(
        children: [
          Positioned(
            top: 0,
            left: 0,
            width: borderSize,
            height: borderSize,
            child: ImageLoad.loadAssetsSvg('topleft'),
          ),
          Positioned(
            top: 0,
            right: 0,
            width: borderSize,
            height: borderSize,
            child: ImageLoad.loadAssetsSvg('topright'),
          ),
          Positioned(
            bottom: 0,
            left: 0,
            width: borderSize,
            height: borderSize,
            child: ImageLoad.loadAssetsSvg('bottomleft'),
          ),
          Positioned(
            bottom: 0,
            right: 0,
            width: borderSize,
            height: borderSize,
            child: ImageLoad.loadAssetsSvg('bottomright'),
          ),
        ],
      ),
    );
  }
}
