import 'package:account_center/common/utils/dialog_loading.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';
import 'package:get/get.dart';

class AlertUtil {
  /// 隐藏加载框
  static void dismissLoading() {
    if (Get.isDialogOpen != null && Get.isDialogOpen!) {
      Get.back();
    }
  }

  /// 显示加载框
  static void showLoading({String text = ''}) {
    dismissLoading();
    Get.dialog(
      LoadingDialog(text: text),
      barrierDismissible: false,
      transitionDuration: const Duration(milliseconds: 200),
    );
  }
}
