import 'package:account_center/common/utils/throttle_util.dart';
import 'package:account_center/style/style_params.dart';
import 'package:flutter/material.dart';

/// 通用普通按钮
class ButtonPublicRadius extends StatelessWidget {
  final String text;
  final Function? onPress;
  final double width;
  final double height;
  final EdgeInsetsGeometry margin;
  final double radius;

  const ButtonPublicRadius(
      {Key? key,
      required this.text,
      required this.onPress,
      this.width = double.infinity,
      this.height = 45.0,
      this.margin = const EdgeInsets.symmetric(horizontal: 15),
      this.radius = 8})
      : super(key: key);

  @override
  Widget build(BuildContext context) {
    return InkWell(
      onTap: ThrottleUtil().throttle(onPress),
      child: Container(
        height: height,
        width: width,
        margin: margin,
        decoration: BoxDecoration(
          color: StyleParams.themeColor,
          borderRadius:
              BorderRadius.circular(StyleParams.buttonIsCircle ? 100 : radius),
        ),
        alignment: Alignment.center,
        child: Text(
          text,
          style: TextStyle(
            fontSize: 15,
            color: Colors.white,
            fontWeight: FontWeight.w600,
          ),
        ),
      ),
    );
  }
}
