import 'package:account_center/page/account_center/account_cancellation/account_cancellation_binding.dart';
import 'package:account_center/page/account_center/account_cancellation/account_cancellation_view.dart';
import 'package:account_center/page/account_center/account_center_binding.dart';
import 'package:account_center/page/account_center/account_center_view.dart';
import 'package:account_center/page/account_center/account_info/account_info_binding.dart';
import 'package:account_center/page/account_center/account_info/account_info_view.dart';
import 'package:account_center/page/account_center/change_password/change_password_binding.dart';
import 'package:account_center/page/account_center/change_password/change_password_view.dart';
import 'package:account_center/page/account_center/change_phone/change_phone_binding.dart';
import 'package:account_center/page/account_center/change_phone/change_phone_view.dart';
import 'package:account_center/page/account_center/change_phone_confirm/change_phone_confirm_binding.dart';
import 'package:account_center/page/account_center/change_phone_confirm/change_phone_confirm_view.dart';
import 'package:account_center/page/account_center/company_manager/company_manager_binding.dart';
import 'package:account_center/page/account_center/company_manager/company_manager_view.dart';
import 'package:account_center/page/account_center/identity_user_id_card/identity_user_id_card_binding.dart';
import 'package:account_center/page/account_center/identity_user_id_card/identity_user_id_card_view.dart';
import 'package:account_center/page/account_center/modify_name/modify_name_binding.dart';
import 'package:account_center/page/account_center/modify_name/modify_name_view.dart';
import 'package:account_center/page/account_center/real_name/real_name_binding.dart';
import 'package:account_center/page/account_center/real_name/real_name_view.dart';
import 'package:account_center/page/account_center/sign_history/sign_history_binding.dart';
import 'package:account_center/page/account_center/sign_history/sign_history_view.dart';
import 'package:account_center/page/account_center/user_seal_identification/user_seal_identification_binding.dart';
import 'package:account_center/page/account_center/user_seal_identification/user_seal_identification_view.dart';
import 'package:account_center/page/account_company/company_auth/company_auth_binding.dart';
import 'package:account_center/page/account_company/company_auth/company_auth_view.dart';
import 'package:account_center/page/account_company/company_auth_guide/company_auth_guide_binding.dart';
import 'package:account_center/page/account_company/company_auth_guide/company_auth_guide_view.dart';
import 'package:account_center/page/account_company/company_auth_result/company_auth_result_binding.dart';
import 'package:account_center/page/account_company/company_auth_result/company_auth_result_view.dart';
import 'package:account_center/page/account_company/company_home/company_manage_binding.dart';
import 'package:account_center/page/account_company/company_home/company_manage_view.dart';
import 'package:account_center/page/account_company/company_sign/company_sign_binding.dart';
import 'package:account_center/page/account_company/company_sign/company_sign_view.dart';
import 'package:account_center/page/account_company/stamp_manage/stamp_manage_binding.dart';
import 'package:account_center/page/account_company/stamp_manage/stamp_manage_view.dart';
import 'package:account_center/page/account_company/stamp_use_history/stamp_use_history_binding.dart';
import 'package:account_center/page/account_company/stamp_use_history/stamp_use_history_view.dart';
import 'package:account_center/page/enterprise/audit_staff/audit_staff_binding.dart';
import 'package:account_center/page/enterprise/audit_staff/audit_staff_view.dart';
import 'package:account_center/page/enterprise/certification/certification_tip/certification_tip_binding.dart';
import 'package:account_center/page/enterprise/certification/certification_tip/certification_tip_view.dart';
import 'package:account_center/page/enterprise/certification/enterprise_message_certification/enterprise_message_certification_binding.dart';
import 'package:account_center/page/enterprise/certification/enterprise_message_certification/enterprise_message_certification_view.dart';
import 'package:account_center/page/enterprise/certification/signature/signature_binding.dart';
import 'package:account_center/page/enterprise/certification/signature/signature_view.dart';
import 'package:account_center/page/enterprise/department_management/department_management_binding.dart';
import 'package:account_center/page/enterprise/department_management/department_management_view.dart';
import 'package:account_center/page/enterprise/department_select/department_select_binding.dart';
import 'package:account_center/page/enterprise/department_select/department_select_view.dart';
import 'package:account_center/page/enterprise/enterprise_product/enterprise_product_binding.dart';
import 'package:account_center/page/enterprise/enterprise_product/enterprise_product_view.dart';
import 'package:account_center/page/enterprise/invite_members/invite_members_binding.dart';
import 'package:account_center/page/enterprise/invite_members/invite_members_view.dart';
import 'package:account_center/page/enterprise/join_or_new_enterprise_page/enterprise_basic_info_page/enterprise_basic_info_binding.dart';
import 'package:account_center/page/enterprise/join_or_new_enterprise_page/enterprise_basic_info_page/enterprise_basic_info_view.dart';
import 'package:account_center/page/enterprise/join_or_new_enterprise_page/enterprise_basic_info_see_page/enterprise_basic_info_see_binding.dart';
import 'package:account_center/page/enterprise/join_or_new_enterprise_page/enterprise_basic_info_see_page/enterprise_basic_info_see_view.dart';
import 'package:account_center/page/enterprise/join_or_new_enterprise_page/enterprise_header_and_name_page/enterprise_header_and_name_binding.dart';
import 'package:account_center/page/enterprise/join_or_new_enterprise_page/enterprise_header_and_name_page/enterprise_header_and_name_view.dart';
import 'package:account_center/page/enterprise/join_or_new_enterprise_page/enterprise_legal_person_page/enterprise_legal_person_binding.dart';
import 'package:account_center/page/enterprise/join_or_new_enterprise_page/enterprise_legal_person_page/enterprise_legal_person_view.dart';
import 'package:account_center/page/enterprise/join_or_new_enterprise_page/enterprise_legal_person_see_page/enterprise_legal_person_see_view.dart';
import 'package:account_center/page/enterprise/join_or_new_enterprise_page/enterprise_legal_person_see_page/legal_person_see_binding.dart';
import 'package:account_center/page/enterprise/join_or_new_enterprise_page/enterprise_proxy_person_page/enterprise_proxy_person_binding.dart';
import 'package:account_center/page/enterprise/join_or_new_enterprise_page/enterprise_proxy_person_page/enterprise_proxy_person_view.dart';
import 'package:account_center/page/enterprise/join_or_new_enterprise_page/enterprise_proxy_person_see_page/enterprise_proxy_person_see_view.dart';
import 'package:account_center/page/enterprise/join_or_new_enterprise_page/enterprise_proxy_person_see_page/proxy_person_see_binding.dart';
import 'package:account_center/page/enterprise/join_or_new_enterprise_page/join_enterprise_code_page/join_enterprise_code_binding.dart';
import 'package:account_center/page/enterprise/join_or_new_enterprise_page/join_enterprise_code_page/join_enterprise_code_view.dart';
import 'package:account_center/page/enterprise/join_or_new_enterprise_page/join_enterprise_page/join_enterprise_binding.dart';
import 'package:account_center/page/enterprise/join_or_new_enterprise_page/join_enterprise_page/join_enterprise_view.dart';
import 'package:account_center/page/enterprise/join_or_new_enterprise_page/join_enterprise_record_page/join_enterprise_record_binding.dart';
import 'package:account_center/page/enterprise/join_or_new_enterprise_page/join_enterprise_record_page/join_enterprise_record_view.dart';
import 'package:account_center/page/enterprise/join_or_new_enterprise_page/join_or_new_enterprise_binding.dart';
import 'package:account_center/page/enterprise/join_or_new_enterprise_page/join_or_new_enterprise_view.dart';
import 'package:account_center/page/enterprise/join_or_new_enterprise_page/new_enterprise_page/new_enterprise_binding.dart';
import 'package:account_center/page/enterprise/join_or_new_enterprise_page/new_enterprise_page/new_enterprise_view.dart';
import 'package:account_center/page/enterprise/join_or_new_enterprise_page/new_enterprise_record_page/new_enterprise_record_binding.dart';
import 'package:account_center/page/enterprise/join_or_new_enterprise_page/new_enterprise_record_page/new_enterprise_record_view.dart';
import 'package:account_center/page/enterprise/join_or_new_enterprise_page/new_enterprise_see_page/new_enterprise_see_binding.dart';
import 'package:account_center/page/enterprise/join_or_new_enterprise_page/new_enterprise_see_page/new_enterprise_see_view.dart';
import 'package:account_center/page/enterprise/join_or_new_enterprise_page/update_company_name_page/update_company_name_binding.dart';
import 'package:account_center/page/enterprise/join_or_new_enterprise_page/update_company_name_page/update_company_name_view.dart';
import 'package:account_center/page/enterprise/organization_structure/change_department/change_department_binding.dart';
import 'package:account_center/page/enterprise/organization_structure/change_department/change_department_view.dart';
import 'package:account_center/page/enterprise/organization_structure/create_department/create_department_binding.dart';
import 'package:account_center/page/enterprise/organization_structure/create_department/create_department_view.dart';
import 'package:account_center/page/enterprise/organization_structure/department_setting_page/department_setting_binding.dart';
import 'package:account_center/page/enterprise/organization_structure/department_setting_page/department_setting_view.dart';
import 'package:account_center/page/enterprise/organization_structure/new_position_page/new_position_binding.dart';
import 'package:account_center/page/enterprise/organization_structure/new_position_page/new_position_view.dart';
import 'package:account_center/page/enterprise/organization_structure/organization_structure_binding.dart';
import 'package:account_center/page/enterprise/organization_structure/organization_structure_view.dart';
import 'package:account_center/page/enterprise/organization_structure/position_details_page/position_details_binding.dart';
import 'package:account_center/page/enterprise/organization_structure/position_details_page/position_details_view.dart';
import 'package:account_center/page/enterprise/organization_structure/position_setting_page/position_setting_binding.dart';
import 'package:account_center/page/enterprise/organization_structure/position_setting_page/position_setting_view.dart';
import 'package:account_center/page/enterprise/organization_structure/set_user_department/set_user_department_binding.dart';
import 'package:account_center/page/enterprise/organization_structure/set_user_department/set_user_department_view.dart';
import 'package:account_center/page/enterprise/role_management/new_role_page/new_role_binding.dart';
import 'package:account_center/page/enterprise/role_management/new_role_page/new_role_view.dart';
import 'package:account_center/page/enterprise/role_management/product_details_permission_page/product_details_permission_binding.dart';
import 'package:account_center/page/enterprise/role_management/product_details_permission_page/product_details_permission_view.dart';
import 'package:account_center/page/enterprise/role_management/product_list_page/product_list_binding.dart';
import 'package:account_center/page/enterprise/role_management/product_list_page/product_list_view.dart';
import 'package:account_center/page/enterprise/role_management/role_details_page/role_details_binding.dart';
import 'package:account_center/page/enterprise/role_management/role_details_page/role_details_view.dart';
import 'package:account_center/page/enterprise/role_management/role_management_binding.dart';
import 'package:account_center/page/enterprise/role_management/role_management_view.dart';
import 'package:account_center/page/enterprise/role_management/role_setting_page/role_setting_binding.dart';
import 'package:account_center/page/enterprise/role_management/role_setting_page/role_setting_view.dart';
import 'package:account_center/page/login/login_binding.dart';
import 'package:account_center/page/login/login_view.dart';
import 'package:account_center/page/position/edit_or_new_position/edit_or_new_position_binding.dart';
import 'package:account_center/page/position/edit_or_new_position/edit_or_new_position_view.dart';
import 'package:account_center/page/position/position_detail/position_detail_binding.dart';
import 'package:account_center/page/position/position_detail/position_detail_view.dart';
import 'package:account_center/page/position/position_manage/position_manage_binding.dart';
import 'package:account_center/page/position/position_manage/position_manage_view.dart';
import 'package:account_center/page/position/position_select/position_select_binding.dart';
import 'package:account_center/page/position/position_select/position_select_view.dart';
import 'package:account_center/page/staff_manager/add_staff/staff_add_binding.dart';
import 'package:account_center/page/staff_manager/add_staff/staff_add_view.dart';
import 'package:account_center/page/staff_manager/edit_people/edit_people_binding.dart';
import 'package:account_center/page/staff_manager/edit_people/edit_people_view.dart';
import 'package:account_center/page/staff_manager/member_manage_main/member_manage_main_binding.dart';
import 'package:account_center/page/staff_manager/member_manage_main/member_manage_main_view.dart';
import 'package:account_center/page/staff_manager/no_depart_user_list/no_depart_user_list_binding.dart';
import 'package:account_center/page/staff_manager/no_depart_user_list/no_depart_user_list_view.dart';
import 'package:account_center/page/staff_manager/position_tree/position_tree_binding.dart';
import 'package:account_center/page/staff_manager/position_tree/position_tree_view.dart';
import 'package:account_center/page/staff_manager/role_select/role_select_binding.dart';
import 'package:account_center/page/staff_manager/role_select/role_select_view.dart';
import 'package:account_center/page/staff_manager/staff_detail/staff_detail_binding.dart';
import 'package:account_center/page/staff_manager/staff_detail/staff_detail_view.dart';
import 'package:account_center/page/staff_manager/staff_manager_main/staff_manager_main_binding.dart';
import 'package:account_center/page/staff_manager/staff_manager_main/staff_manager_main_view.dart';
import 'package:account_center/page/staff_manager/staff_select_page/staff_select_binding.dart';
import 'package:account_center/page/staff_manager/staff_select_page/staff_select_view.dart';
import 'package:account_center/page/test_menu.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

//路由管理
class RouteConfig {
  static const String testMenu = '/testMenu';
  static const String loginPage = '/login/loginPage';
  static const String accountCenter = '/account_center';

  /// 人员管理主页面
  static const String staffManagerMainPage =
      '/staff_manager/staffManagerMainPage';

  /// 添加人员
  static const String staffAddPage = '/staff_manager/staffAddPage';

  /// 人员详情
  static const String staffDetailPage = '/staff_manager/staffDetailPage';

  /// 选择角色
  static const String roleSelectPage = '/staff_manager/RoleSelectPage';

  /// 选择职位
  // static const String positionSelectPage = '/staff_manager/PositionSelectPage';

  /// 职位树
  static const String positionTreePage = '/staff_manager/PositionTreePage';

  /// 企业管理
  static const String enterpriseManagementPage =
      '/enterprise/enterpriseManagementPage';

  /// 企业产品
  static const String enterpriseProductPage =
      '/enterprise_product/enterpriseProductPage';

  /// 邀请成员
  static const String inviteMemberPage = '/invite_member/inviteMemberPage';

  ///组织架构
  static const String organizationStructurePage =
      '/organization_structure/organizationStructurePage';

  ///组织架构-创建部门
  static const String createDepartment =
      '/organization_structure/create_department/createDepartmentPage';

  ///角色管理
  static const String roleManagementPage =
      '/role_management/roleManagementPage';

  ///部门管理
  static const String departmentManagementPage =
      '/department_management/departmentManagementPage';

  ///账号中心
  static const String accountCenterPage = '/account_center/accountCenterPage';

  ///企业管理
  static const String companyManager = '/account_center/CompanyManagerPage';

  ///新增角色
  static const String newRolePage = '$roleManagementPage/newRolePage';

  ///产品列表
  static const String productListPage = '$roleManagementPage/productListPage';

  ///角色详情
  static const String roleDetailsPage = '$roleManagementPage/roleDetailsPage';

  ///产品权限详情
  static const String productDetailsPermissionPage =
      '$roleManagementPage/productDetailsPermissionPage';

  ///角色设置
  static const String roleSettingPage = '$roleManagementPage/roleSettingPage';

  ///加入/创建企业
  static const String joinOrNewEnterprisePage =
      '$enterpriseManagementPage/joinOrNewEnterprisePage';

  ///加入企业
  static const String joinEnterprisePage =
      '$enterpriseManagementPage/joinEnterprisePage';

  ///创建企业
  static const String newEnterprisePage =
      '$enterpriseManagementPage/newEnterprisePage';

  ///加入企业记录
  static const String joinEnterpriseRecordPage =
      '$enterpriseManagementPage/joinEnterpriseRecordPage';

  ///加入企业记录
  static const String newEnterpriseRecordPage =
      '$enterpriseManagementPage/newEnterpriseRecordPage';

  ///企业代理人信息
  static const String enterpriseProxyPersonPage =
      '$enterpriseManagementPage/enterpriseProxyPersonPage';

  ///企业基础信息
  static const String enterpriseBasicInfoPage =
      '$enterpriseManagementPage/enterpriseBasicInfoPage';

  ///企业法人信息
  static const String enterpriseLegalPersonPage =
      '$enterpriseManagementPage/enterpriseLegalPersonPage';

  ///加入企业(邀请码)
  static const String joinEnterpriseCodePage =
      '$enterpriseManagementPage/joinEnterpriseCodePage';

  ///账户信息
  static const String accountInfoPage = '/account_center/AccountInfoPage';

  ///实名认证
  static const String realNamePage = '/account_center/real_name/realNamePage';

  ///修改密码
  static const String changePasswordPage =
      '/account_center/change_password/changePasswordPage';

  ///查看企业基本信息
  static const String enterpriseBasicSeePage =
      '$enterpriseManagementPage/enterpriseBasicSeePage';

  ///查看企业代理人信息
  static const String enterpriseProxySeePage =
      '$enterpriseManagementPage/enterpriseProxySeePage';

  ///查看法人信息
  static const String enterpriseLegalSeePage =
      '$enterpriseManagementPage/enterpriseLegalSeePage';

  ///查看创建企业记录列表-item
  static const String enterpriseSeePage =
      '$enterpriseManagementPage/enterpriseSeePage';

  ///修改姓名
  static const String modifyNamePage =
      '/account_center/modify_name/modifyNamePage';

  ///新建职位
  static const String newPositionPage =
      '$organizationStructurePage/newPositionPage';

  ///人员列表 (选中)
  static const String staffListSelectPage =
      '$staffManagerMainPage/staffListSelectPage';

  ///职位详情(角色详情 人员详情)
  static const String positionDetailsPage =
      '$organizationStructurePage/positionDetailsPage';

  ///职位设置
  static const String positionSettingPage =
      '$organizationStructurePage/positionSettingPage';

  ///部门设置
  static const String departmentSettingPage =
      '$organizationStructurePage/departmentSettingPage';

  /// 员工审核
  static const String auditStaffPage = '/enterprise/audit_staff/auditStaffPage';

  /// 企业简称
  static const String enterpriseHeaderAndNamePage =
      '$enterpriseManagementPage/enterpriseHeaderAndNamePage';

  ///企业简称编辑页
  static const String updateCompanyShortNameInfoPage =
      '$enterpriseManagementPage/updateCompanyShortNameInfoPage';

  ///企业认证
  static const String enterpriseCertificationTip =
      '$enterpriseManagementPage/enterpriseCertificationTip';

  ///企业认证信息
  static const String enterpriseMessageCertificationPage =
      '$enterpriseManagementPage/enterpriseMessageCertificationPage';

  ///签章认证结果
  static const String signatureResult =
      '$enterpriseManagementPage/signatureResult';

  /// 职位管理
  static const String positionManagePage = '/position/positionManagePage';

  /// 职位管理
  static const String positionSelectPage = '/position/PositionSelectPage';

  /// 职位详情
  static const String positionDetailPage = '/position/PositionDetailPage';

  /// 编辑和新建职位
  static const String editOrNewPositionPage = '/position/editOrNewPositionPage';

  static const String memberManagerMainPage =
      '/staff_manager/memberManagerMainPage';

  static const String editPeoplePage = '/staff_manager/editPeoplePage';

  /// 部门选择
  static const String departmentSelectPage = '/enterprise/DepartmentSelectPage';

  /// 选择用户修改部门
  static const String changeDepartmentPage = '/enterprise/ChangeDepartmentPage';

  /// 设置用户部门
  static const String setUserDepartmentPage =
      '/enterprise/SetUserDepartmentPage';

  static const String noDeptUserPage = '/staff_manager/NoDepartUserListPage';

  static const String accountCancellationPage =
      '/account_center/AccountCancellationPage';

  static const String changePhoneConfirm =
      '/account_center/ChangePhoneConfirmPage';

  static const String changePhone = '/account_center/ChangePhonePage';

  /// 实名认证身份证识别
  static const String identityUserIdCardPage =
      '/account_center/IdentityUserIdCardPage';

  /// 签订记录
  static const String signHistory = '/account_center/SignHistoryView';

/**
 * 2024-02-19 新版企业认证
 */

  /// 企业认证相关
  static const String accountCompany = '/account_center/account_company';

  /// 企业主页
  static const String companyHome = '$accountCompany/home';

  /// 实名认证引导
  static const String companyAuthGuide = '$accountCompany/companyAuthGuide';

  /// 实名认证
  static const String companyAuth = '$accountCompany/companyAuth';

  /// 企业认证结果
  static const String companyAuthResult = '$accountCompany/companyAuthResult';

  /// 企业签章信息确认页面
  static const String companySign = '$accountCompany/companySign';

  /// 企业签章授权结果
  static const String companySignResult = '$accountCompany/companySignResult';

  /// 企业签章管理
  static const String stampManage = '$accountCompany/stampManage';

  /// 企业签章使用记录
  static const String stampUseHistory = '$accountCompany/stampUseHistory';

  static const String userSeal = '$accountCenter/UserSealIdentificationPage';

  static final List<GetPage> routePages = [
    GetPage(
      name: testMenu,
      page: () => const TestMenu(),
      binding: TestMenuBinding(),
    ),
    GetPage(
      name: loginPage,
      page: () => LoginPage(),
      binding: LoginBinding(),
    ),
    GetPage(
      name: staffManagerMainPage,
      page: () => StaffManagerMainPage(),
      binding: StaffManagerMainBinding(),
    ),
    GetPage(
      name: staffAddPage,
      page: () => StaffAddPage(),
      binding: StaffAddBinding(),
    ),
    GetPage(
      name: staffDetailPage,
      page: () => StaffDetailPage(),
      binding: StaffDetailBinding(),
    ),
    GetPage(
      name: companyHome,
      page: () => CompanyManageView(),
      binding: CompanyManageBind(),
    ),
    GetPage(
      name: enterpriseProductPage,
      page: () => EnterpriseProductPage(),
      binding: EnterpriseProductBinding(),
    ),
    GetPage(
      name: inviteMemberPage,
      page: () => InviteMembersPage(),
      binding: InviteMembersBinding(),
    ),
    GetPage(
      name: organizationStructurePage,
      page: () => OrganizationStructurePage(),
      binding: OrganizationStructureBinding(),
    ),
    GetPage(
      name: roleManagementPage,
      page: () => RoleManagementPage(),
      binding: RoleManagementBinding(),
    ),
    GetPage(
      name: departmentManagementPage,
      page: () => DepartmentManagementPage(),
      binding: DepartmentManagementBinding(),
    ),
    GetPage(
      name: accountCenterPage,
      page: () => AccountCenterPage(),
      binding: AccountCenterBinding(),
    ),
    GetPage(
      name: newRolePage,
      page: () => NewRolePage(),
      binding: NewRoleBinding(),
    ),
    GetPage(
      name: productListPage,
      page: () => ProductListPage(),
      binding: ProductListBinding(),
    ),
    GetPage(
      name: roleSelectPage,
      page: () => RoleSelectPage(),
      binding: RoleSelectBinding(),
    ),
    GetPage(
      name: roleDetailsPage,
      page: () => RoleDetailsPage(),
      binding: RoleDetailsBinding(),
    ),
    GetPage(
      name: positionSelectPage,
      page: () => PositionSelectPage(),
      binding: PositionSelectBinding(),
    ),
    GetPage(
      name: productDetailsPermissionPage,
      page: () => ProductDetailsPermissionPage(),
      binding: ProductDetailsPermissionBinding(),
    ),
    GetPage(
      name: roleSettingPage,
      page: () => RoleSettingPage(),
      binding: RoleSettingBinding(),
    ),
    GetPage(
      name: accountInfoPage,
      page: () => AccountInfoPage(),
      binding: AccountInfoBinding(),
    ),
    GetPage(
      name: joinOrNewEnterprisePage,
      page: () => JoinOrNewEnterprisePage(),
      binding: JoinOrNewEnterpriseBinding(),
    ),
    GetPage(
      name: newEnterprisePage,
      page: () => NewEnterprisePage(),
      binding: NewEnterpriseBinding(),
    ),
    GetPage(
      name: joinEnterprisePage,
      page: () => JoinEnterprisePage(),
      binding: JoinEnterpriseBinding(),
    ),
    GetPage(
      name: joinEnterpriseRecordPage,
      page: () => JoinEnterpriseRecordPage(),
      binding: JoinEnterpriseRecordBinding(),
    ),
    GetPage(
      name: newEnterpriseRecordPage,
      page: () => NewEnterpriseRecordPage(),
      binding: NewEnterpriseRecordBinding(),
    ),
    GetPage(
      name: enterpriseProxyPersonPage,
      page: () => EnterpriseProxyPersonPage(),
      binding: EnterpriseProxyPersonBinding(),
    ),
    GetPage(
      name: enterpriseBasicInfoPage,
      page: () => EnterpriseBasicInfoPage(),
      binding: EnterpriseBasicInfoBinding(),
    ),
    GetPage(
      name: enterpriseLegalPersonPage,
      page: () => EnterpriseLegalPersonPage(),
      binding: EnterpriseLegalPersonBinding(),
    ),
    GetPage(
      name: joinEnterpriseCodePage,
      page: () => JoinEnterpriseCodePage(),
      binding: JoinEnterpriseCodeBinding(),
    ),
    GetPage(
      name: realNamePage,
      page: () => RealNamePage(),
      binding: RealNameBinding(),
    ),
    GetPage(
      name: changePasswordPage,
      page: () => ChangePasswordPage(),
      binding: ChangePasswordBinding(),
    ),
    GetPage(
      name: modifyNamePage,
      page: () => ModifyNamePage(),
      binding: ModifyNameBinding(),
    ),
    GetPage(
      name: enterpriseSeePage,
      page: () => NewEnterpriseSeePage(),
      binding: NewEnterpriseSeeBinding(),
    ),
    GetPage(
      name: enterpriseBasicSeePage,
      page: () => EnterpriseBasicInfoSeePage(),
      binding: EnterpriseBasicInfoSeeBinding(),
    ),
    GetPage(
      name: enterpriseProxySeePage,
      page: () => EnterpriseProxyPersonSeePage(),
      binding: EnterpriseProxyPersonSeeBinding(),
    ),
    GetPage(
      name: enterpriseLegalSeePage,
      page: () => EnterpriseLegalPersonSeePage(),
      binding: EnterpriseLegalPersonSeeBinding(),
    ),
    GetPage(
      name: createDepartment,
      page: () => CreateDepartmentPage(),
      binding: CreateDepartmentBinding(),
    ),
    GetPage(
      name: newPositionPage,
      page: () => NewPositionPage(),
      binding: NewPositionBinding(),
    ),
    GetPage(
      name: staffListSelectPage,
      page: () => StaffSelectPage(),
      binding: StaffSelectBinding(),
    ),
    GetPage(
      name: positionDetailsPage,
      page: () => PositionDetailsPage(),
      binding: PositionDetailsBinding(),
    ),
    GetPage(
      name: positionSettingPage,
      page: () => PositionSettingPage(),
      binding: PositionSettingBinding(),
    ),
    GetPage(
      name: departmentSettingPage,
      page: () => DepartmentSettingPage(),
      binding: DepartmentSettingBinding(),
    ),
    GetPage(
      name: positionTreePage,
      page: () => PositionTreePage(),
      binding: PositionTreeBinding(),
    ),
    GetPage(
      name: companyManager,
      page: () => CompanyManagerPage(),
      binding: CompanyManagerBinding(),
    ),
    GetPage(
      name: auditStaffPage,
      page: () => AuditStaffPage(),
      binding: AuditStaffBinding(),
    ),
    GetPage(
      name: enterpriseHeaderAndNamePage,
      page: () => EnterpriseHeaderAndNamePage(),
      binding: EnterpriseHeaderAndNameBinding(),
    ),
    GetPage(
      name: updateCompanyShortNameInfoPage,
      page: () => UpdateCompanyShortNameInfoPage(),
      binding: UpdateCompanyShortNameInfoBinding(),
    ),
    GetPage(
      name: enterpriseCertificationTip,
      page: () => CertificationTipPage(),
      binding: CertificationTipBinding(),
    ),
    GetPage(
      name: enterpriseMessageCertificationPage,
      page: () => EnterpriseMessageCertificationPage(),
      binding: EnterpriseMessageCertificationBinding(),
    ),
    GetPage(
      name: signatureResult,
      page: () => SignaturePage(),
      binding: SignatureBinding(),
    ),
    GetPage(
      name: positionManagePage,
      page: () => PositionManagePage(),
      binding: PositionManageBinding(),
    ),
    GetPage(
      name: editOrNewPositionPage,
      page: () => EditOrNewPositionPage(),
      binding: EditOrNewPositionBinding(),
    ),
    GetPage(
      name: memberManagerMainPage,
      page: () => MemberManageMainPage(),
      binding: MemberManageMainBinding(),
    ),
    GetPage(
      name: editPeoplePage,
      page: () => EditPeoplePage(),
      binding: EditPeopleBinding(),
    ),
    GetPage(
      name: departmentSelectPage,
      page: () => DepartmentSelectPage(),
      binding: DepartmentSelectBinding(),
    ),
    GetPage(
      name: changeDepartmentPage,
      page: () => ChangeDepartmentPage(),
      binding: ChangeDepartmentBinding(),
    ),
    GetPage(
      name: setUserDepartmentPage,
      page: () => SetUserDepartmentPage(),
      binding: SetUserDepartmentBinding(),
    ),
    GetPage(
      name: noDeptUserPage,
      page: () => NoDepartUserListPage(),
      binding: NoDepartUserListBinding(),
    ),
    GetPage(
      name: positionDetailPage,
      page: () => PositionDetailPage(),
      binding: PositionDetailBinding(),
    ),
    GetPage(
      name: accountCancellationPage,
      page: () => AccountCancellationPage(),
      binding: AccountCancellationBinding(),
    ),
    GetPage(
      name: changePhoneConfirm,
      page: () => ChangePhoneConfirmPage(),
      binding: ChangePhoneConfirmBinding(),
    ),
    GetPage(
      name: changePhone,
      page: () => ChangePhonePage(),
      binding: ChangePhoneBinding(),
    ),
    GetPage(
      name: identityUserIdCardPage,
      page: () => IdentityUserIdCardPage(),
      binding: IdentityUserIdCardBinding(),
    ),
    GetPage(
      name: signHistory,
      page: () => SignHistoryView(),
      binding: SignHistoryBind(),
    ),
    GetPage(
      name: companyAuthGuide,
      page: () => CompanyAuthGuideView(),
      binding: CompanyAuthGuideBind(),
    ),
    GetPage(
      name: companyAuth,
      page: () => CompanyAuthView(),
      binding: CompanyAuthBind(),
    ),
    GetPage(
      name: companyAuthResult,
      page: () => CompanyAuthResultView(),
      binding: CompanyAuthResultBind(),
    ),
    GetPage(
      name: companySign,
      page: () => CompanySignView(),
      binding: CompanySignBind(),
    ),
    GetPage(
      name: stampManage,
      page: () => StampManageView(),
      binding: StampManageBind(),
    ),
    GetPage(
      name: stampUseHistory,
      page: () => StampUseHistoryView(),
      binding: StampUseHistoryBind(),
    ),
    GetPage(
      name: userSeal,
      page: () => UserSealIdentificationPage(),
      binding: UserSealIdentificationBinding(),
    ),
  ];
}
