import 'package:account_center/account_center.dart';
import 'package:account_center/api/base_model.dart';
import 'package:account_center/common/sp/sp_key.dart';
import 'package:account_center/page/staff_manager/model/staff_model.dart';
import 'package:flutter_clx_base/widget/my_refresh_list_public.dart';

import 'staff_manager_main_state.dart';

class StaffManagerMainLogic extends GetxController
    with GetSingleTickerProviderStateMixin {
  // 页面刷新id
  int userList = 0, examine = 1;

  final StaffManagerMainState state = StaffManagerMainState();
  // 员工列表
  late MyListController userListController;

  late String companyNo;

  /// 人员名称 搜索关键字
  String searchKey = '';

  @override
  void onInit() {
    userListController = MyListController();
    companyNo = SpUtil.getString(SPKey.companyNo) ?? '';
    super.onInit();
  }

  /// 请求数据
  void getItemList(
      int page, int pageSize, SuccessCallback success, ErrorCallback error) {
    fetchList(Method.post, url: HttpApi.listCompanyUsers, params: {
      'page': page,
      'pageSize': pageSize,
      'companyNo': companyNo,
      'searchKey': searchKey
    }, onSuccess: (response) {
      success(response);
    }, onError: (code, message) {
      success([]);
    });
  }

  /// 添加人员
  void add() {
    Get.toNamed(RouteConfig.staffAddPage);
  }

  /// 人员详情
  void toStaffDetail(StaffModel staff) {
    Get.toNamed(RouteConfig.staffDetailPage, arguments: {
      'userNo': staff.userNo,
      'companyNo': companyNo,
    });
  }

  /// 搜索
  void search(String key) {
    userListController.callRefresh();
  }

  /// 搜索框字符变化
  void searchKeyChange(String? value) {
    searchKey = value ?? '';
    userListController.callRefresh();
  }
}
