import 'package:account_center/account_center.dart';
import 'package:account_center/page/staff_manager/staff_detail/staff_detail_logic.dart';
import 'package:account_center/page/staff_manager/widget/user_departments.dart';
import 'package:account_center/page/staff_manager/widget/user_message_show.dart';
import 'package:account_center/widget/no_data.dart';
import 'package:flutter/material.dart';

class UserBaseMessage extends StatelessWidget {
  UserBaseMessage({Key? key}) : super(key: key);

  final logic = Get.find<StaffDetailLogic>();

  @override
  Widget build(BuildContext context) {
    return logic.hasBaseMessage()
        ? Padding(
            padding: const EdgeInsets.symmetric(horizontal: 10),
            child: SingleChildScrollView(
              child: Column(
                children: [
                  UserDepartments(
                    logic.departmentList,
                    title: '所属部门',
                  ),
                  SizedBox(
                    height: 10,
                  ),
                  UserMessageShow(
                    logic.roleList,
                    title: '角色',
                    nameKey: 'roleName',
                  ),
                  SizedBox(
                    height: 10,
                  ),
                  UserMessageShow(
                    logic.positionList,
                    title: '职位',
                    nameKey: 'positionName',
                  ),
                ],
              ),
            ),
          )
        : NoData();
  }
}
