import 'package:account_center/common/product_menu_control.dart';
import 'package:account_center/common/res/colors.dart';
import 'package:account_center/common/res/text_style.dart';
import 'package:account_center/common/utils/image_load.dart';
import 'package:account_center/page/account_company/company_auth/widget/common/gesture_tap.dart';
import 'package:account_center/page/staff_manager/staff_detail/widget/role_detail.dart';
import 'package:account_center/page/staff_manager/staff_detail/widget/user_base_message.dart';
import 'package:account_center/style/style_params.dart';
import 'package:account_center/style/widget/bottom_buttons.dart';
import 'package:account_center/style/widget/my_tab_bar.dart';
import 'package:account_center/widget/no_app_bar_scaffold.dart';
import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

import 'staff_detail_logic.dart';

class StaffDetailPage extends StatelessWidget {
  final logic = Get.find<StaffDetailLogic>();

  StaffDetailPage({super.key});

  final tabTextStyle = TextStyle(
    color: Color(0xff222222),
    fontSize: 15,
    fontWeight: FontWeight.w600,
  );

  @override
  Widget build(BuildContext context) {
    return NoAppBarScaffold(
      imageUrl: StyleParams.userDetailBg,
      bottomButton: bottomButton(),
      child: GetBuilder<StaffDetailLogic>(builder: (s) {
        return Column(children: [
          makeAppbar(),
          // 基本信息
          commonMessage(context),
          SizedBox(height: 7),
          tabBar(),
          vGap10,
          tabBarView(),
        ]);
      }),
    );
  }

  Widget bottomButton() {
    return GetBuilder<StaffDetailLogic>(
      builder: (logic) {
        return Visibility(
          visible: hasMenuPermission('func_user_edit'),
          child: BottomButtons(
            items: [
              ButtonItem(
                title: '编辑',
                onClick: logic.editPeople,
              ),
              ButtonItem(
                title: logic.detail['status'] == 10 ? '禁用' : '启用',
                onClick: logic.enableUser,
              ),
              ButtonItem(
                title: '离职',
                onClick: logic.remove,
                isDelete: true,
              ),
            ],
          ),
        );
      },
    );
  }

  Expanded tabBarView() {
    return Expanded(
      child: TabBarView(
        controller: logic.controller,
        children: [
          UserBaseMessage(),
          RoleDetail(),
        ],
      ),
    );
  }

  Widget tabBar() {
    return Container(
      margin: EdgeInsets.only(left: 15),
      child: MyTabBar(
        tabs: ['基本详情', '角色管理'],
        controller: logic.controller,
      ),
    );
  }

  Container bottomBarSplitLine() {
    return Container(
      color: Color(0xffE1E1E2),
      width: 0.5,
      height: 24,
    );
  }

  Widget makeAppbar() {
    return Padding(
      padding: const EdgeInsets.symmetric(
        horizontal: 16,
        vertical: 8,
      ),
      child: Row(
        mainAxisAlignment: MainAxisAlignment.spaceBetween,
        children: [
          IconButton(
            onPressed: () {
              logic.back();
            },
            icon: Icon(
              Icons.arrow_back_ios,
              color: StyleParams.appBarTextColor,
            ),
            color: RColors.mainContentColor,
          ),
          Text(
            '人员详情',
            style: TextStyle(
              color: StyleParams.appBarTextColor,
              fontSize: 18,
            ),
          ),
          //站位
          IconButton(
            onPressed: () {},
            icon: Icon(Icons.arrow_back_ios),
            color: Colors.transparent,
          ),
        ],
      ),
    );
  }

  Widget commonMessage(BuildContext context) {
    return Stack(
      children: [
        Container(
          margin: EdgeInsets.only(left: 10, top: 35, right: 10),
          padding: EdgeInsets.only(left: 25, top: 0, right: 25, bottom: 25),
          decoration: BoxDecoration(
              color: Colors.white, borderRadius: BorderRadius.circular(8)),
          child: Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              SizedBox(
                height: 47,
                child: Row(
                  mainAxisAlignment: MainAxisAlignment.end,
                  children: [],
                ),
              ),
              Row(
                children: [
                  Text(
                    logic.detail['userName'] ?? '',
                    style: TextStyle(
                        color: Color(0xff171A1D),
                        fontSize: 18,
                        fontWeight: FontWeight.w500),
                  ),
                  hGap10,
                ],
              ),
              vGap8,
              Text(
                logic.detail['userMobile'] ?? '',
                style: TextStyle(color: Color(0xff68717C), fontSize: 14),
              ),
              vGap8,
              Text(
                '入职时间：${logic.detail['inductionDate'] ?? ''}',
                style: TextStyle(color: Color(0xff68717C), fontSize: 14),
              ),
            ],
          ),
        ),
        Container(
          margin: EdgeInsets.only(left: 35),
          width: 70,
          height: 70,
          child: ImageLoad.user(logic.detail['headImg'], width: 70, height: 70),
        ),
      ],
    );
  }

  Widget textButton(String title, void Function() onTab,
      {bool isDelete = false}) {
    return Expanded(
      flex: 1,
      child: Center(
        child: TextButton(
          style: ButtonStyle(
              foregroundColor: isDelete
                  ? MaterialStateProperty.all(RColors.deleteColor)
                  : MaterialStateProperty.all(StyleParams.themeColor)),
          onPressed: onTab,
          child: Text(title),
        ),
      ),
    );
  }

  /// 移除员工
  Widget _removePositionMember() {
    return GestureTapWidget(
      onTap: logic.removeFromPosition,
      child: Container(
        padding: EdgeInsets.only(bottom: 30, top: 15),
        decoration: BoxDecoration(boxShadow: const [
          BoxShadow(
            color: Color(0x05000000),
            offset: Offset(1, -2),
          )
        ], color: Colors.white),
        alignment: Alignment.center,
        child: Text(
          '离职',
          style: RTextStyle.deleteButtonStyle,
        ),
      ),
    );
  }
}
