import 'package:account_center/api/base_model.dart';
import 'package:account_center/common/sp/sp_key.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';
import 'package:flutter_clx_base/widget/my_refresh_list_public.dart';

import '../../../routes/route_config.dart';

class NoDepartUserListLogic extends GetxController {
  List<dynamic> users = [];

  var controller = MyListController();

  void requestData(
      int page, int pageSize, SuccessCallback success, ErrorCallback error) {
    fetch(Method.post, url: HttpApi.pageNoDeptUsers, params: {
      'page': page,
      'pageSize': pageSize,
      'companyNo': SpUtil.getString(SPKey.companyNo),
    }, onSuccess: (response) {
      users.clear();
      users.addAll(response['records']);
      success(response['records']);
    }, onError: (code, msg) {
      error(code, msg);
    });
  }

  void addPeople() {
    Get.toNamed(RouteConfig.staffAddPage);
  }

  void changeDepartment() {
    Get.toNamed(RouteConfig.changeDepartmentPage, arguments: {'data': users})
        ?.then((value) {
      controller.callRefresh();
    });
  }

  toUserDetail(element) {
    Get.toNamed(RouteConfig.staffDetailPage, arguments: {
      'userNo': element['userNo'],
      'companyNo': SpUtil.getString(SPKey.companyNo),
    });
  }
}
