import 'package:account_center/page/staff_manager/model/staff_model.dart';

extension StaffModelExtesion on StaffModel {
  ///	10: 启用
  /// 20：禁用
  bool get isForbid {
    return status == 20;
  }

  /// 认证状态:10-未注册,20-待实名,30-已实名
  bool get isIdentification {
    return authStatus == 30;
  }

  StaffType getType() {
    switch (type) {
      case 1:
        return StaffType.manager;
      case 2:
        return StaffType.normal;
      default:
        return StaffType.normal;
    }
  }

  List<String> getPositions() {
    var positions = <String>[];
    if (departmentAndPositionVos != null) {
      departmentAndPositionVos?.forEach((element) {
        if (element.department?.isNotEmpty == true) {
          positions.add('${element.department}-${element.position ?? ''}');
        } else {
          positions.add(element.position ?? '');
        }
      });
    }
    return positions;
  }
}

enum StaffType {
  /// 管理员
  manager,

  /// 普通员工
  normal,
}
