import 'package:account_center/common/res/text_style.dart';
import 'package:account_center/common/utils/image_load.dart';
import 'package:account_center/page/account_company/company_auth/widget/common/gesture_tap.dart';
import 'package:account_center/style/style_widget.dart';
import 'package:account_center/style/widget/edit_app_bar.dart';
import 'package:account_center/widget/no_data.dart';
import 'package:account_center/widget/search_bar.dart' as search_bar;
import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';
import 'package:flutter_clx_base/widget/my_refresh_list_public.dart';

import 'position_select_logic.dart';

/// 选择角色
class PositionSelectPage extends StatelessWidget {
  final logic = Get.find<PositionSelectLogic>();
  final state = Get.find<PositionSelectLogic>().state;

  PositionSelectPage({super.key});

  @override
  Widget build(BuildContext context) {
    return MyScaffold(
      appBar: EditAppBar(
        title: '职位列表',
        cancel: () => Get.back(),
        confirm: () => logic.finish(),
      ),
      body: GetBuilder<PositionSelectLogic>(
        builder: (s) {
          return Column(
            children: [
              search_bar.MySearchBar(
                backgroundColor: Colors.white,
                onChange: (value) => logic.setKey(value),
                onSearchClick: (value) => logic.search(value),
              ),
              Expanded(
                child: state.noData
                    ? NoData()
                    : MyListViewPublic(
                        controller: logic.controller,
                        padding: EdgeInsets.only(top: 10),
                        pageSize: 30,
                        itemBuilder: (context, index, role) {
                          return makeItem(role);
                        },
                        requestData: (int page,
                            int pageSize,
                            dynamic Function(List<dynamic>) success,
                            dynamic Function(int, String) error) {
                          logic.requestData(page, pageSize, success, error);
                        },
                      ),
              )
            ],
          );
        },
      ),
    );
  }

  GestureTapWidget makeItem(position) {
    bool isForbid = state.forbidNo.contains(position['positionNo']);
    return GestureTapWidget(
      onTap: () {
        if (!isForbid) {
          logic.check(position, position['checked'] != true);
        }
      },
      child: Container(
        decoration: BoxDecoration(
            color: Colors.white, borderRadius: BorderRadius.circular(8)),
        margin: EdgeInsets.only(left: 10, right: 10, bottom: 10),
        child: Padding(
          padding:
              const EdgeInsets.only(left: 10, top: 10, right: 20, bottom: 10),
          child: Row(
            children: [
              ImageLoad.svgTagIcon('zhiwei'),
              hGap15,
              Expanded(
                  child: Text(
                position['positionName'],
                style: RTextStyle.mainContentStyle,
              )),
              StyleWidget.checkBox(position['checked'] == true || isForbid,
                  (value) {
                logic.check(position, value == true);
              }, forbid: isForbid),
            ],
          ),
        ),
      ),
    );
  }
}
