import 'package:account_center/common/product_menu_control.dart';
import 'package:account_center/common/utils/image_load.dart';
import 'package:account_center/style/style_widget.dart';
import 'package:account_center/style/widget/my_app_bar.dart';
import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

import 'position_detail_logic.dart';

class PositionDetailPage extends StatelessWidget {
  final logic = Get.find<PositionDetailLogic>();

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: MyAppBar('职位详情'),
      body: GetBuilder<PositionDetailLogic>(builder: (logic) {
        return CustomScrollView(
          slivers: [
            SliverToBoxAdapter(
              child: Column(
                children: [
                  _inputName(),
                  SizedBox(height: 10),
                  userCountTitle(logic),
                  SizedBox(height: 1),
                ],
              ),
            ),
            SliverFixedExtentList(
              delegate: SliverChildBuilderDelegate(
                (context, index) {
                  return _itemViewPro(
                    logic.personList.getElement(index),
                  );
                },
                childCount: logic.personList.length,
              ),
              itemExtent: 75,
            ),
          ],
        );
      }),
    );
  }

  Container userCountTitle(PositionDetailLogic logic) {
    return Container(
      padding: EdgeInsets.symmetric(horizontal: 20, vertical: 15),
      color: Colors.white,
      child: Row(
        children: [
          Expanded(
            child: Text(
              "职位人员（${logic.personList.length}）",
              style: TextStyle(
                fontSize: 16,
                fontWeight: FontWeight.bold,
              ),
            ),
          ),
        ],
      ),
    );
  }

  Widget _itemViewPro(item) {
    return Container(
      padding: EdgeInsets.symmetric(horizontal: 15),
      margin: EdgeInsets.only(left: 10, right: 10, top: 10),
      decoration: BoxDecoration(
        color: Colors.white,
        borderRadius: BorderRadius.circular(8),
      ),
      child: Row(
        children: [
          ImageLoad.user(item['headImg'],
              width: 42, height: 42, type: ImageTransformerType.circle),
          hGap15,
          Expanded(
            child: Text(
              item['userName'] ?? '',
              style: TextStyle(fontSize: 16, fontWeight: FontWeight.bold),
            ),
          ),
        ],
      ),
    );
  }

  ///职位名称
  Widget _inputName() {
    // return FormShow(
    //   title: '职位名称',
    //   content: logic.positionName,
    // );
    return Container(
      color: Colors.white,
      padding: EdgeInsets.symmetric(horizontal: 25, vertical: 15),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Row(
            children: [
              Expanded(
                child: Row(
                  children: [
                    Flexible(
                      child: Text(
                        logic.positionName,
                        style: TextStyle(
                          fontSize: 18,
                          fontWeight: FontWeight.bold,
                        ),
                      ),
                    ),
                  ],
                ),
              ),
              Visibility(
                visible: _canEdit(),
                child: StyleWidget.textButton('编辑', () {
                  logic.editPosition();
                }),
              )
            ],
          ),
        ],
      ),
    );
  }

  bool _canEdit() => hasMenuPermission('func_edit_position');
}
