import 'package:account_center/common/res/colors.dart';
import 'package:account_center/page/account_company/company_auth/widget/common/gesture_tap.dart';
import 'package:account_center/style/widget/button_public_radius.dart';
import 'package:account_center/widget/clear_text.dart';
import 'package:account_center/widget/hint_text.dart';
import 'package:account_center/widget/send_v_code.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

import 'login_logic.dart';

class LoginPage extends StatelessWidget {
  final logic = Get.find<LoginLogic>();
  final state = Get.find<LoginLogic>().state;

  LoginPage({super.key});

  @override
  Widget build(BuildContext context) {
    return GestureTapWidget(
      onTap: () {
        state.focusNodePassWord.unfocus();
        state.focusNodeUserName.unfocus();
        state.focusVCode.unfocus();
      },
      child: Scaffold(
        backgroundColor: Colors.white,
        body: SingleChildScrollView(
          child: Column(
            crossAxisAlignment: CrossAxisAlignment.center,
            children: <Widget>[
              Stack(
                alignment: AlignmentDirectional.bottomCenter,
                children: <Widget>[
                  Container(
                      width: double.infinity,
                      height: 150.0,
                      color: Colors.amberAccent,
                      margin: EdgeInsets.only(bottom: 30),
                      child: Text("背景图")),
                  Container(
                    color: RColors.appMain,
                    height: 80,
                    width: 80,
                    child: Center(child: Text("logo")),
                  )
                ],
              ),
              GetBuilder<LoginLogic>(
                assignId: true,
                builder: (logic) {
                  return Padding(
                    padding:
                        const EdgeInsets.only(left: 30, right: 30, top: 30),
                    child: Column(
                      children: <Widget>[
                        //用户名
                        Row(
                          children: <Widget>[
                            Icon(
                              Icons.phone_iphone,
                              color: RColors.appMain,
                            ),
                            Expanded(
                              flex: 1,
                              child: Padding(
                                padding: const EdgeInsets.only(
                                    left: 8.0, right: 8.0),
                                child: ClearText(
                                    state.uNameController, "17638537269",
                                    hintSize: 14.0,
                                    focusNode: state.focusNodeUserName,
                                    callBack: (value) {
                                  state.userNameNum = value;
                                  logic.update();
                                }),
                              ),
                            ),
                          ],
                        ),
                        //分割线
                        Divider(
                          height: 8,
                        ),
                        //密码登录输入框
                        Offstage(
                          offstage: !state.isPwdLogin,
                          child: Row(
                            children: <Widget>[
                              Icon(
                                Icons.lock,
                                color: RColors.appMain,
                              ),
                              Expanded(
                                flex: 1,
                                child: Padding(
                                  padding: const EdgeInsets.only(
                                      left: 8.0, right: 8.0),
                                  child: HintText(
                                    state.pwdController,
                                    "请输入密码",
                                    focusNode: state.focusNodePassWord,
                                    callBack: (value) {
                                      state.passWordNum = value;
                                      logic.update();
                                    },
                                    inputFormatter: [
                                      FilteringTextInputFormatter.allow(
                                          RegExp("[a-zA-Z0-9]")),
                                      LengthLimitingTextInputFormatter(12)
                                    ],
                                  ),
                                ),
                              ),
                            ],
                          ),
                        ),
                        //验证码登录输入框
                        Offstage(
                          offstage: state.isPwdLogin,
                          child: Row(
                            children: <Widget>[
                              Icon(
                                Icons.verified_user,
                                color: RColors.appMain,
                              ),
                              Expanded(
                                flex: 1,
                                child: Padding(
                                  padding: const EdgeInsets.only(left: 8.0),
                                  child: ClearText(
                                      state.codeController, "请输入验证码",
                                      maxLength: 6,
                                      hintSize: 14.0,
                                      focusNode: state.focusVCode,
                                      callBack: (value) {
                                    state.vCodeNum = value;
                                    logic.update();
                                  }),
                                ),
                              ),
                              Container(
                                color: RColors.appMain,
                                margin: EdgeInsets.only(right: 5),
                                width: 1,
                                height: 20,
                              ),
                              Container(
                                alignment: Alignment.center,
                                width: 110.0,
                                child: Padding(
                                  padding: EdgeInsets.only(right: 0),
                                  child: SendVCode('captchaUserLogin', () {
                                    return state.uNameController.value.text;
                                  }),
                                ),
                              ),
                            ],
                          ),
                        ),
                        //分割线
                        Divider(
                          height: 8,
                        ),
                        //忘记密码
                        Container(
                          alignment: Alignment.topRight,
                          height: 100,
                          child: Offstage(
                            offstage: !state.isPwdLogin,
                            child: Row(
                              mainAxisAlignment: MainAxisAlignment.end,
                              children: <Widget>[
                                Padding(
                                    padding: EdgeInsets.only(top: 20.0),
                                    child: InkWell(
                                      onTap: () {},
                                      child: Text(
                                        "忘记密码?",
                                        style: TextStyle(color: Colors.grey),
                                      ),
                                    )),
                              ],
                            ),
                          ),
                        ),
                        //登录按钮
                        Offstage(
                          offstage: !state.isPwdLogin,
                          child: Container(
                              margin: EdgeInsets.only(bottom: 20),
                              child: ButtonPublicRadius(
                                  text: '登 录',
                                  onPress: (state.userNameNum > 10 &&
                                          state.passWordNum > 1)
                                      ? () {
                                          logic.loginByPassword();
                                        }
                                      : null)),
                        ),
                        Offstage(
                          offstage: state.isPwdLogin,
                          child: Container(
                              margin: EdgeInsets.only(bottom: 20),
                              child: ButtonPublicRadius(
                                  text: '登 录',
                                  onPress: (state.userNameNum > 10 &&
                                          state.vCodeNum > 1)
                                      ? () {
                                          logic.loginByCode();
                                        }
                                      : null)),
                        ),
                        //登录方式
                        Row(
                          mainAxisAlignment: MainAxisAlignment.spaceEvenly,
                          children: <Widget>[
                            InkWell(
                              onTap: () {
                                state.isPwdLogin = !state.isPwdLogin;
                                logic.update();
                              },
                              child: Text(
                                state.isPwdLogin ? "快速登录" : "密码登录",
                                style: TextStyle(color: RColors.appMain),
                              ),
                            ),
                            Container(
                              color: RColors.appMain,
                              width: 1,
                              height: 20,
                            ),
                            //注册账号按钮
                            InkWell(
                              onTap: () {},
                              child: Text(
                                "注册账号",
                                style: TextStyle(color: RColors.appMain),
                              ),
                            )
                          ],
                        )
                      ],
                    ),
                  );
                },
              ),
            ],
          ),
        ),
      ),
    );
  }
}
