import 'package:account_center/common/utils/image_load.dart';
import 'package:account_center/style/widget/button_public_radius_outline_theme.dart';
import 'package:account_center/style/widget/my_app_bar.dart';
import 'package:account_center/widget/unordered_list.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

class CancellationEnterprise extends StatelessWidget {
  const CancellationEnterprise({Key? key}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: MyAppBar('账户注销'),
      body: Container(
        color: Colors.white,
        width: double.infinity,
        margin: EdgeInsets.only(top: 10),
        padding: EdgeInsets.symmetric(horizontal: 20),
        child: Column(
          mainAxisSize: MainAxisSize.min,
          children: [
            SizedBox(height: 20),
            ImageLoad.loadAssertImage('circle_warning', width: 52, height: 52),
            SizedBox(height: 20),
            Text('请登录账户中心电脑端申请企业注销：'),
            SizedBox(height: 8),
            UnorderedList(items: [
              '仅企业创建人可申请注销企业',
              RichText(
                text: TextSpan(children: [
                  TextSpan(
                    text: '进入 ',
                    style: _textStyle(),
                  ),
                  TextSpan(
                    text: '账户中心',
                    style: _textStyle().copyWith(fontWeight: FontWeight.w600),
                  ),
                  TextSpan(
                    text: ' > ',
                    style: _textStyle(),
                  ),
                  TextSpan(
                    text: '企业信息 ',
                    style: _textStyle().copyWith(fontWeight: FontWeight.bold),
                  ),
                  TextSpan(
                    text: ' 菜单，在页面右上角点击 申请注销 按钮发起申请。',
                    style: _textStyle(),
                  ),
                ]),
              ),
            ]),
            SizedBox(height: 20)
          ],
        ),
      ),
      bottomNavigationBar: SafeArea(
        child: ButtonPublicRadiusOutlineTheme(
          text: '复制电脑端地址',
          onPress: () {
            Clipboard.setData(
              ClipboardData(text: 'https://user-system.91msl.com/home'),
            );
            ToastUtil.showToast('复制成功');
          },
          margin: EdgeInsets.symmetric(horizontal: 15, vertical: 15),
        ),
      ),
    );
  }

  TextStyle _textStyle() {
    return const TextStyle(
        fontSize: 14.0, color: Color(0xFF344254), height: 1.45);
  }
}
