import 'package:account_center/api/base_model.dart';
import 'package:account_center/common/sp/sp_util.dart';
import 'package:account_center/routes/route_config.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';
import 'package:flutter_clx_base/widget/my_refresh_list_public.dart';

import 'role_management_state.dart';

const deleteRole = 'deleteRole';
const updateRole = 'updateRole';
const newRole = 'newRole';

class RoleManagementLogic extends GetxController {
  final RoleManagementState state = RoleManagementState();
  var controller = MyListController();
  var key = '';

  var focusNode = FocusNode();

  void getRoleListRequest(
      int page, int pageSize, Function success, Function error) {
    fetchList(Method.post, url: HttpApi.roleManagerList, onSuccess: (data) {
      success(data);
    }, onError: (code, message) {
      success([]);
    }, params: {
      "companyNo": getCompanyNo(),
      "page": page,
      "pageSize": pageSize,
      'roleName': key
      /*"roleName": "0",
      "roleNo": 0,
      "roleStrategy": 0,
      "roleType": 1,
      "status": 10*/
    });
  }

  void goToRoleDetails(String? roleNo) {
    Get.toNamed(RouteConfig.roleDetailsPage, arguments: {'roleNo': roleNo})
        ?.then((value) => _refreshResult(value));
    focusNode.unfocus();
  }

  void goToNewRolePage() {
    Get.toNamed(RouteConfig.newRolePage)
        ?.then((value) => _refreshResult(value));
    focusNode.unfocus();
  }

  void _refreshResult(value) {
    if (value is String) {
      //删除角色 刷新
      controller.callRefresh();
    }
  }

  void onChange(String value) {
    key = value;
    controller.callRefresh();
  }

  onSearch(String value) {
    key = value;
    controller.callRefresh();
  }
}
