import 'package:account_center/common/product_menu_control.dart';
import 'package:account_center/common/res/colors.dart';
import 'package:account_center/common/res/text_style.dart';
import 'package:account_center/common/utils/image_load.dart';
import 'package:account_center/page/enterprise/role_management/role_details_page/pages/depart_list.dart';
import 'package:account_center/page/enterprise/role_management/role_details_page/pages/product_list.dart';
import 'package:account_center/page/enterprise/role_management/role_details_page/pages/user_list.dart';
import 'package:account_center/style/style_params.dart';
import 'package:account_center/style/style_widget.dart';
import 'package:account_center/style/widget/my_app_bar.dart';
import 'package:account_center/style/widget/my_tab_bar.dart';
import 'package:account_center/widget/asset_image_widget.dart';
import 'package:account_center/widget/no_data.dart';
import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

import 'role_details_logic.dart';

///角色详情
class RoleDetailsPage extends StatelessWidget {
  final logic = Get.find<RoleDetailsLogic>();
  final state = Get.find<RoleDetailsLogic>().state;

  RoleDetailsPage({super.key});

  @override
  Widget build(BuildContext context) {
    return MyScaffold(
      appBar: MyAppBar('角色详情'),
      body: _bodyContent(context),
    );
  }

  Widget _bodyContent(context) {
    return GetBuilder<RoleDetailsLogic>(builder: (logic) {
      return Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          _textWidget(context),
          Expanded(
            child: Column(
              children: [
                Container(
                  padding: EdgeInsets.only(left: 10),
                  child: MyTabBar(
                    tabs: ['产品', '人员', '部门'],
                    controller: logic.controller,
                  ),
                ),
                Expanded(
                  child: TabBarView(
                    controller: logic.controller,
                    children: [
                      RoleProductListPage(),
                      UserListPage(),
                      DepartListPage(),
                    ],
                  ),
                )
              ],
            ),
          ),
        ],
      );
    });
  }

  ///标题栏
  Widget _titleBarWidget() {
    return Padding(
      padding: EdgeInsets.symmetric(horizontal: 15, vertical: 7),
      child: Stack(
        alignment: Alignment.centerLeft,
        children: [
          InkWell(
            onTap: () {
              Get.back();
            },
            child: SizedBox(
              width: 35,
              height: 35,
              child: Icon(
                color: Colors.black,
                Icons.arrow_back_ios,
                size: 25,
              ),
            ),
          ),
          Row(
            mainAxisAlignment: MainAxisAlignment.center,
            children: [
              Text(
                "角色信息",
                style: TextStyle(fontSize: 18, fontWeight: FontWeight.bold),
              ),
              Visibility(visible: true, child: Text("")),
            ],
          )
        ],
      ),
    );
  }

  ///名称 权限 描述
  Widget _textWidget(context) {
    return Stack(
      children: [
        Container(
          color: Colors.white,
          padding: EdgeInsets.symmetric(horizontal: 25, vertical: 15),
          child: Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              Row(
                children: [
                  Expanded(
                    child: Row(
                      children: [
                        Flexible(
                          child: Text(
                            state.data?['roleName'] ?? '',
                            style: TextStyle(
                              fontSize: 18,
                              fontWeight: FontWeight.bold,
                            ),
                          ),
                        ),
                        hGap15,
                        AssetImageWidget(
                            width: 12,
                            height: 12,
                            imgFileName: 'ic_role_jurisdiction'),
                        hGap5,
                        Text(
                          state.data?['roleStrategyMsg'] ?? '',
                          style: TextStyle(fontSize: 10),
                        ),
                      ],
                    ),
                  ),
                  StyleWidget.textButton('编辑', () {
                    logic.goToRoleSettingPage();
                  })
                ],
              ),
              vGap5,
              Text(
                (state.data?['roleDescribe'].toString().isNotEmpty == true)
                    ? state.data['roleDescribe']
                    : '暂无描述',
                style: TextStyle(color: RColors.hintColor),
              )
            ],
          ),
        ),
        Positioned(
          right: 0,
          child: Visibility(
            visible: state.data != null && state.data?['status'] != 10,
            child: AssetImageWidget(
              imgFileName: 'ic_forbid',
              height: 40,
              width: 70,
            ),
          ),
        )
      ],
    );
  }

  ///列表
  Widget _productListWidget() {
    return state.listPro.isEmpty
        ? NoData()
        : ListView.builder(
            itemBuilder: (context, index) {
              return _itemViewPro(state.listPro[index]);
            },
            itemCount: state.listPro.length,
          );
  }

  ///列表item
  Widget _itemViewPro(entity) {
    return InkWell(
      onTap: () {
        if (state.from == 'user') {
          return;
        }
        if (hasMenuPermission('btn_set_role_product') ||
            hasMenuPermission('btn_remove_role_product')) {
          logic.gotoProductPermissionPage(entity);
        }
      },
      child: Container(
        margin: EdgeInsets.symmetric(horizontal: 5),
        child: Card(
          elevation: 0,
          child: Container(
            padding: EdgeInsets.symmetric(horizontal: 15, vertical: 10),
            child: Row(
              children: [
                ImageLoad.productIcon(entity['productImgUrl'],
                    width: 50, height: 50, type: ImageTransformerType.rect),
                hGap15,
                Expanded(
                  child: Column(
                    mainAxisAlignment: MainAxisAlignment.center,
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Text(
                        entity['productName'] ?? '',
                        style: TextStyle(
                            fontSize: 16, fontWeight: FontWeight.bold),
                      ),
                      vGap8,
                      Text(
                        entity['productDescribe'] ?? '',
                        style:
                            TextStyle(fontSize: 12, color: RColors.hintColor),
                      )
                    ],
                  ),
                ),
                Visibility(
                  visible: state.from != 'user' &&
                      (hasMenuPermission('btn_set_role_product') ||
                          hasMenuPermission('btn_remove_role_product')),
                  child: TextButton.icon(
                    onPressed: () {
                      logic.gotoProductPermissionPage(entity);
                    },
                    icon: AssetImageWidget(
                      imgFileName: 'ic_permission',
                      height: 16,
                      width: 16,
                    ),
                    label: Text(
                      "设置",
                      style: TextStyle(
                        color: Color(0xFF165DFF),
                      ),
                    ),
                  ),
                ),
              ],
            ),
          ),
        ),
      ),
    );
  }

  Widget _itemBottom(context) {
    return Container(
      color: Colors.white,
      child: Row(
        mainAxisAlignment: MainAxisAlignment.spaceEvenly,
        children: [
          _itemBottomBtn(context, "新增产品", () {
            logic.goToAddProductPage();
          }, hasMenuPermission('btn_role_add_product')),
          _itemBottomBtn(
            context,
            "角色设置",
            () {
              logic.goToRoleSettingPage();
            },
            hasMenuPermission('btn_update_role') ||
                hasMenuPermission('btn_delete_role_'),
          ),
        ],
      ),
    );
  }

  ///从员工列表进入
  Widget _itemBottomDelete(context) {
    return Container(
      color: Colors.white,
      child: Row(
        mainAxisAlignment: MainAxisAlignment.spaceEvenly,
        children: [
          _itemBottomBtn(context, "移除此角色", () {
            logic.deleteUserRoleRequest();
          }, true, delete: true),
        ],
      ),
    );
  }

  //从角色列表进入
  Widget _itemBottomBtn(
    context,
    String name,
    onTap,
    bool show, {
    bool delete = false,
  }) {
    return InkWell(
      child: Visibility(
        visible: show,
        child: Container(
          color: Colors.white,
          padding: const EdgeInsets.all(20.0),
          child: Text(
            name,
            style: delete
                ? RTextStyle.deleteButtonStyle
                : TextStyle(fontSize: 16, color: StyleParams.themeColor),
          ),
        ),
      ),
      onTap: () {
        onTap();
      },
    );
  }
}
