import 'package:account_center/api/base_model.dart';
import 'package:account_center/common/sp/sp_util.dart';
import 'package:account_center/routes/route_config.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

import 'product_list_state.dart';

class ProductListLogic extends GetxController {
  final ProductListState state = ProductListState();

  List<String> listSelect = [];
  dynamic data;

  @override
  void onInit() {
    super.onInit();
    data = Get.arguments ?? {};
    listSelect = (data ?? []);
  }

  void productListRequest(int page, int pageSize, Function success) {
    fetchList(
      Method.get,
      url: HttpApi.productCompanyList,
      queryParameters: {"companyNo": getCompanyNo()},
      onSuccess: (data) {
        success(_setCheckedItem(data));
      },
    );
  }

  ///置灰
  List _setCheckedItem(listProducts) {
    var result = <dynamic>[];
    for (int j = 0; j < listProducts.length; j++) {
      dynamic product = listProducts[j];
      if (!listSelect.contains(product['productCode'])) {
        result.add(product);
      }
    }
    return result;
  }

  void goToProductDetailsPage(entity) {
    if (entity['isChecked'] ?? false) {
      ToastUtil.showToast('产品不能重复添加');
      return;
    }
    Get.toNamed(RouteConfig.productDetailsPermissionPage,
            arguments: {'entity': entity, 'menuList': entity['menuList']})
        ?.then((value) {
      Get.back(
          result: {'menuList': value['menuList'], 'entity': value['entity']});
    });
  }
}
