import 'package:account_center/common/res/colors.dart';
import 'package:account_center/common/utils/image_load.dart';
import 'package:account_center/style/style_widget.dart';
import 'package:account_center/style/widget/edit_app_bar.dart';
import 'package:account_center/widget/asset_image_widget.dart';
import 'package:account_center/widget/confirm_dialog.dart';
import 'package:account_center/widget/form/form_input.dart';
import 'package:account_center/widget/form/form_row.dart';
import 'package:account_center/widget/form/form_show.dart';
import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

import 'new_role_logic.dart';

///新增角色 Page
class NewRolePage extends StatelessWidget {
  final logic = Get.find<NewRoleLogic>();
  final state = Get.find<NewRoleLogic>().state;

  NewRolePage({super.key});

  @override
  Widget build(BuildContext context) {
    return WillPopScope(
      onWillPop: () async {
        _cancelRoleDialog(context);
        return false;
      },
      child: Scaffold(
          appBar: EditAppBar(
            title: "新增角色",
            cancel: () {
              _cancelRoleDialog(context);
            },
            confirm: () {
              logic.completed();
            },
            showCancel: false,
          ),
          body: _bodyContent(context)),
    );
  }

  Widget _bodyContent(context) {
    return GetBuilder<NewRoleLogic>(
      assignId: true,
      builder: (controller) {
        return SingleChildScrollView(
          child: Column(
            mainAxisAlignment: MainAxisAlignment.start,
            children: [
              SizedBox(height: 10),
              FormInput(
                title: "角色名称",
                controller: state.controllerName,
                focusNode: FocusNode(),
                maxLength: 10,
              ),
              itemStrategy(onChanged: (value) {
                if (value != null) {
                  logic.radioChange(value);
                }
              }),
              FormInput(
                title: "描述",
                controller: state.controllerDescribe,
                focusNode: FocusNode(),
                maxLength: 200,
              ),
              SizedBox(
                height: 10,
              ),
              FormShow(
                title: '产品权限',
                content: '',
              ),
              _addProductItem(),
              SizedBox(
                height: 1,
              ),
              ...state.listSelected.map<Widget>((e) {
                return _itemViewPro(e);
              }).toList()
            ],
          ),
        );
      },
    );
  }

  Container _addProductItem() {
    return Container(
      padding: EdgeInsets.symmetric(horizontal: 20, vertical: 15),
      alignment: Alignment.topLeft,
      color: Colors.white,
      child: InkWell(
        onTap: () {
          logic.goToProductListPage();
        },
        child: Row(
          children: [
            Icon(
              Icons.add,
              color: Colors.black,
              size: 16,
            ),
            hGap4,
            Expanded(
              child: Text(
                "添加产品",
                style: TextStyle(
                    fontSize: 16,
                    color: Color(0xFF171A1D),
                    fontWeight: FontWeight.w500),
              ),
            )
          ],
        ),
      ),
    );
  }

  ///角色策略
  Widget itemStrategy({required ValueChanged<int?> onChanged}) {
    return FormRow(
      crossAxisAlignment: CrossAxisAlignment.start,
      vCap: 12,
      title: "角色策略",
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          _itemRadio("无策略", 0, onChanged: onChanged),
          _radioSecondTitle('角色默认无任何权限'),
          SizedBox(
            height: 4,
          ),
          // _itemRadio("所有权限", 1, onChanged: onChanged),
          // _radioSecondTitle('角色默认具有所有产品的全部权限'),
          // SizedBox(
          //   height: 4,
          // ),
          _itemRadio("默认菜单", 2, onChanged: onChanged),
          _radioSecondTitle('角色默认具有它关联产品的默认权限'),
        ],
      ),
    );
  }

  Widget _radioSecondTitle(String title) {
    return Container(
      margin: EdgeInsets.only(left: 20),
      child: Text(
        title,
        style: TextStyle(color: Color(0xFF909399), fontSize: 12),
      ),
    );
  }

  Widget _itemRadio(String name, int num,
      {required ValueChanged<int?> onChanged}) {
    return StyleWidget.itemRadio(
      num,
      state.radioIndex,
      name,
      (value) {
        onChanged(value);
      },
    );
  }

  ///状态 switch
  Widget itemBottomSwitch() {
    return FormRow(
      title: "状态",
      vCap: 6,
      child: Row(
        children: [
          Expanded(
            child: Text(
              state.switchState ? '启用' : '禁用',
              style: TextStyle(fontSize: 16.0, fontWeight: FontWeight.bold),
            ),
          ),
          StyleWidget.switchButton(
            state.switchState,
            (value) {
              logic.switchChange(value);
            },
          ),
        ],
      ),
    );
  }

  void _cancelRoleDialog(context) {
    ConfirmDialog(
      content: '是否取消新增角色',
      confirm: () {
        if (Navigator.canPop(context)) {
          Get.back(result: "success");
        }
      },
    ).show();
  }

  ///产品列表条目
  Widget _itemViewPro(item) {
    return Container(
      margin: EdgeInsets.only(bottom: 1),
      padding: EdgeInsets.symmetric(horizontal: 20, vertical: 10),
      color: Colors.white,
      child: Row(
        children: [
          InkWell(
            onTap: () {
              logic.deleteProduct(item);
            },
            child: Icon(
              Icons.remove_circle_outlined,
              color: Colors.red,
              size: 22,
            ),
          ),
          ImageLoad.productIcon(
            item['productImgUrl'],
            width: 50,
            height: 50,
          ),
          hGap15,
          Expanded(
            child: InkWell(
              child: Column(
                mainAxisAlignment: MainAxisAlignment.center,
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  Text(
                    item['productName'] ?? '',
                    style: TextStyle(fontSize: 16, fontWeight: FontWeight.bold),
                  ),
                  vGap8,
                  Text(
                    item['productTypeMsg'] ?? '',
                    style: TextStyle(fontSize: 12, color: RColors.hintColor),
                  )
                ],
              ),
              onTap: () {
                logic.goToPerPage(item);
              },
            ),
          ),
          TextButton.icon(
            onPressed: () {
              logic.goToPerPage(item);
            },
            icon: AssetImageWidget(
              imgFileName: 'ic_permission',
              height: 16,
              width: 16,
            ),
            label: Text(
              "权限",
              style: TextStyle(
                color: Color(0xFF165DFF),
              ),
            ),
          ),
        ],
      ),
    );
  }
}
