import 'package:account_center/api/base_model.dart';
import 'package:account_center/common/sp/sp_util.dart';
import 'package:account_center/common/utils/dialog_loading.dart';
import 'package:account_center/page/enterprise/role_management/role_management_logic.dart';
import 'package:account_center/routes/route_config.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

import 'new_role_state.dart';

class NewRoleLogic extends GetxController {
  final NewRoleState state = NewRoleState();

  List<dynamic> menuList = [];

  int switchStateValue = 10;

  void back() {
    Get.back();
  }

  void completed() {
    if (state.controllerName.text.isEmpty) {
      ToastUtil.showToast("角色名称不能为空");
      return;
    }
    if (state.controllerName.text.length > 20) {
      ToastUtil.showToast("角色名称不能大于20字");
      return;
    }
    if (state.controllerDescribe.text.length > 200) {
      ToastUtil.showToast("角色描述不能大于200字");
      return;
    }
    KeyBoardUtils.hideKeyboard();
    _newRoleRequest();
  }

  ///新增角色
  void _newRoleRequest() {
    LoadingDialog.showLoading();
    fetch(Method.post, url: HttpApi.newRole, params: {
      "companyNo": getCompanyNo(),
      "roleDescribe": state.controllerDescribe.text,
      "roleName": state.controllerName.text,
      "roleStrategy": state.radioIndex, //0-无策略,1-管理员,2-默认菜单
      "roleType": 3, //1，平台个人 2，平台公司 3，公司员工 4，公司子公司
      "productList": state.listSelected,
    }, onSuccess: (data) {
      _roleSwitchRequest(data);
      ToastUtil.showToast('创建成功');
    }, onError: (msg, code) {
      LoadingDialog.dismissLoading();
    });
  }

  ///角色启用状态
  void _roleSwitchRequest(String roleNo) {
    fetch(Method.get, url: HttpApi.roleSwitch, queryParameters: {
      "roleNo": roleNo,
      "status": switchStateValue,
    }, onSuccess: (data) {
      LoadingDialog.dismissLoading();
      Get.back(result: newRole);
    }, onError: (msg, code) {
      LoadingDialog.dismissLoading();
    });
  }

  ///状态启用开关
  void switchChange(bool value) {
    state.switchState = value;
    state.switchState ? switchStateValue = 10 : switchStateValue = 20;
    update();
  }

  ///角色策略变化
  void radioChange(int value) {
    state.radioIndex = value;
    update();
  }

  ///产品添加  回传处理
  void goToProductListPage() {
    Get.toNamed(
      RouteConfig.productListPage,
      arguments:
          state.listSelected.map<String>((e) => e['productCode']).toList(),
    )?.then((value) {
      if (value != null) {
        removeRepeat(value['entity'], value['menuList']);
      }
      update();
    });
  }

  ///去重
  void removeRepeat(entity, menuList) {
    if (state.listSelected.isEmpty) {
      state.listSelected.add({
        'productCode': entity['productCode'],
        'productTypeMsg': entity['productTypeMsg'],
        'productName': entity['productName'],
        'productImgUrl': entity['productImgUrl'],
        'menuList': menuList
      });
      return;
    }

    for (var element in state.listSelected) {
      if (element['productCode'] != entity['productCode']) {
        state.listSelected.add({
          'productCode': entity['productCode'],
          'productTypeMsg': entity['productTypeMsg'],
          'productImgUrl': entity['productImgUrl'],
          'productName': entity['productName'],
          'menuList': menuList
        });
        break;
      } else {}
    }
  }

  ///移除产品
  void deleteProduct(item) {
    state.listSelected.remove(item);
    update();
  }

  ///权限详情页
  void goToPerPage(item) {
    KeyBoardUtils.hideKeyboard();
    Get.toNamed(RouteConfig.productDetailsPermissionPage,
            arguments: {'entity': item, 'menuList': item['menuList']})
        ?.then((value) {
      if (value != null) {
        item['menuList'] = value['menuList'];
        update();
      }
    });
  }

  void delete() {}
}
