import 'package:account_center/api/base_model.dart';
import 'package:account_center/common/product_menu_control.dart';
import 'package:account_center/common/sp/sp_key.dart';
import 'package:account_center/page/staff_manager/member_manage_event.dart';
import 'package:account_center/page/staff_manager/widget/user_message_show.dart';
import 'package:account_center/routes/route_config.dart';
import 'package:account_center/style/widget/bottom_buttons.dart';
import 'package:account_center/style/widget/my_app_bar.dart';
import 'package:account_center/widget/form/form_show.dart';
import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

class ViewDepartmentPage extends StatefulWidget {
  final dynamic parentDept;
  final String departmentNo;
  const ViewDepartmentPage({
    Key? key,
    required this.departmentNo,
    this.parentDept,
  }) : super(key: key);

  @override
  State<ViewDepartmentPage> createState() => _ViewDepartmentPageState();
}

class _ViewDepartmentPageState extends State<ViewDepartmentPage> {
  dynamic data;
  String pDepartmentName = '';
  @override
  void initState() {
    _requestDepartmentDetail();
    pDepartmentName = widget.parentDept?['departmentName'];
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: MyAppBar('查看部门'),
      body: Column(
        children: [
          FormShow(
            title: '部门名称',
            content: data?['departmentName'],
          ),
          FormShow(
            title: '上级部门',
            content: pDepartmentName,
          ),
          Container(
            color: Colors.white,
            padding: EdgeInsets.only(left: 20, right: 12),
            child: Column(
              children: [
                UserMessageShow(
                  (data?['roles'] ?? []),
                  title: '关联角色',
                  nameKey: 'roleName',
                  titleFontSize: 16,
                ),
                Container(
                  margin: EdgeInsets.symmetric(horizontal: 8),
                  height: 1,
                  child: Divider(
                    height: 1,
                  ),
                )
              ],
            ),
          ),
          Container(
            color: Colors.white,
            padding: EdgeInsets.only(left: 20, right: 12),
            child: UserMessageShow(
              data?['admins'] ?? [],
              title: '部门负责人',
              nameKey: 'userName',
              titleFontSize: 16,
            ),
          ),
        ],
      ),
      bottomNavigationBar: Visibility(
        visible: hasMenuPermission('btn_edit_department'),
        child: BottomButtons(
          items: [ButtonItem(title: '编辑部门', onClick: _toEditDepart)],
        ),
      ),
    );
  }

  String getRoleNames() {
    return (data?['roles'] ?? []).map((e) => e['roleName']).join(',');
  }

  String departmentManagerNames() {
    return (data?['admins'] ?? []).map((e) => e['userName']).join(',');
  }

  void _toEditDepart() {
    Get.toNamed(RouteConfig.createDepartment, arguments: {
      'companyNo': SpUtil.getString(SPKey.companyNo),
      'parentDept': widget.parentDept,
      'departmentNo': widget.departmentNo,
    })?.then((value) {
      /// 部门删除
      if (value['isDelete'] == true) {
        Get.back(result: value);
      } else if (value?['changeDepartment'] == true) {
        /// 编辑部门是更改父部门，需要回到首页
        Get.back(result: value);
      } else {
        MemberManageEvent.refreshData();
        _requestDepartmentDetail();
      }
    });
  }

  void _requestDepartmentDetail() {
    fetch(Method.get, url: HttpApi.departmentDetail, queryParameters: {
      'departmentNo': widget.departmentNo,
    }, onSuccess: (response) {
      setState(() {
        data = response;
      });
    });
  }
}
