import 'package:account_center/api/base_model.dart';
import 'package:account_center/widget/confirm_dialog.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

import 'position_setting_state.dart';

class PositionSettingLogic extends GetxController {
  final PositionSettingState state = PositionSettingState();

  int departmentNo = 0;
  String departmentPno = '0';
  bool fromMyDepartment = false;
  @override
  void onInit() {
    super.onInit();
    state.controller.text = Get.arguments['departmentName'] ?? '';
    departmentNo = Get.arguments['departmentNo'] ?? '';
    departmentPno = Get.arguments['departmentPno'] ?? '';
    state.radioIndex = Get.arguments['adminPosition'] ?? 0;
    fromMyDepartment = Get.arguments['isMyDepartment'] == true;
  }

  void changeRadio(value) {
    state.radioIndex = value;
    update();
  }

  void updatePositionRequest() {
    fetch(Method.post, url: HttpApi.updateDepartmentOrPosition,
        onSuccess: (data) {
      Get.back(result: {});
    }, params: {
      "adminPosition": state.radioIndex,
      "departmentDescribe": '',
      "departmentName": state.controller.text,
      "departmentNo": departmentNo,
      "departmentPno": departmentPno.toInt(),
    });
  }

  ///删除此职位
  void deletePositionRequest() {
    ConfirmDialog(
      content: '确定删除该职位！',
      confirm: () {
        fetch(Method.delete, url: HttpApi.deleteDepartmentOrPosition,
            onSuccess: (data) {
          Get.back(result: 'delete');
          ToastUtil.showToast('删除成功！');
        }, queryParameters: {
          "departmentNo": departmentNo.toInt(),
        });
      },
    ).show();
  }
}
