import 'package:account_center/common/res/colors.dart';
import 'package:account_center/common/utils/image_load.dart';
import 'package:account_center/page/enterprise/organization_structure/new_position_page/new_position_logic.dart';
import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

class TabPersonListPage extends StatelessWidget {
  final logic = Get.find<NewPositionLogic>();
  final state = Get.find<NewPositionLogic>().state;

  TabPersonListPage({super.key});

  @override
  Widget build(BuildContext context) {
    return _proListView(context);
  }

  ///已添加产品列表
  Widget _proListView(context) {
    return CustomScrollView(
      slivers: [
        SliverFixedExtentList(
            delegate: SliverChildBuilderDelegate((context, index) {
              return _itemViewPro(state.personList.getElement(index));
            }, childCount: state.personList.length),
            itemExtent: 70),
        SliverToBoxAdapter(
          child: Container(
            padding: EdgeInsets.symmetric(horizontal: 10, vertical: 15),
            alignment: Alignment.topLeft,
            color: Colors.white,
            child: InkWell(
              onTap: () {
                logic.goToPersonListPage();
              },
              child: Row(
                children: [
                  Icon(
                    Icons.add,
                    color: RColors.mainContentColor,
                  ),
                  hGap5,
                  Expanded(
                      child: Text(
                    "添加人员",
                    style: TextStyle(
                        color: RColors.mainContentColor,
                        fontWeight: FontWeight.w500),
                  ))
                ],
              ),
            ),
          ),
        ),
      ],
    );
  }

  ///产品列表条目
  Widget _itemViewPro(item) {
    return Container(
      margin: EdgeInsets.only(bottom: 1),
      padding: EdgeInsets.symmetric(horizontal: 20, vertical: 10),
      color: Colors.white,
      child: Row(
        children: [
          InkWell(
            onTap: () {
              logic.deletePerson(item);
            },
            child: Icon(
              Icons.remove_circle_outlined,
              color: Colors.red,
            ),
          ),
          ImageLoad.user(item['headImg'],
              width: 50, height: 50, type: ImageTransformerType.circle),
          hGap15,
          Expanded(
              child: Text(
            item['userName'] ?? '',
            style: TextStyle(fontSize: 16, fontWeight: FontWeight.bold),
          )),
        ],
      ),
    );
  }
}
