import 'package:account_center/page/staff_manager/widget/user_message_show.dart';
import 'package:account_center/style/widget/button_public_delete.dart';
import 'package:account_center/style/widget/edit_app_bar.dart';
import 'package:account_center/widget/form/form_input.dart';
import 'package:account_center/widget/form/form_select.dart';
import 'package:account_center/widget/form/form_show.dart';
import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

import 'create_department_logic.dart';

class CreateDepartmentPage extends StatelessWidget {
  final logic = Get.find<CreateDepartmentLogic>();
  final state = Get.find<CreateDepartmentLogic>().state;

  CreateDepartmentPage({super.key});

  @override
  Widget build(BuildContext context) {
    return MyScaffold(
      appBar: EditAppBar(
        title: logic.isCreate
            ? (logic.departmentNo == logic.companyNo ? '新建部门' : '新建子部门')
            : '编辑部门',
        showCancel: false,
        confirm: logic.submit,
      ),
      body: GetBuilder<CreateDepartmentLogic>(builder: (s) {
        return Column(
          children: [
            Visibility(
              visible: !logic.onlyShow,
              child: FormInput(
                title: '部门名称',
                controller: state.nameController,
                focusNode: state.nameNode,
                inputType: TextInputType.text,
                maxLength: 10,
                check: logic.checkName,
                enabled: !logic.onlyShow,
              ),
            ),
            Visibility(
              visible: logic.onlyShow,
              child: FormShow(
                title: '部门编码',
                content: state.nameController.text,
              ),
            ),
            FormSelect(
              title: '上级部门',
              content: logic.selectedParentDepartment?['departmentName'] ?? '',
              onTap: logic.selectDepartment,
              onlyShow: logic.onlyShow,
            ),
            Container(
              color: Colors.white,
              padding: EdgeInsets.only(left: 20, right: 12),
              child: Column(
                children: [
                  UserMessageShow(
                    logic.roleList,
                    title: '关联角色',
                    onCheck: logic.selectRoles,
                    nameKey: 'roleName',
                    titleFontSize: 16,
                  ),
                  Container(
                    margin: EdgeInsets.symmetric(horizontal: 8),
                    height: 1,
                    child: Divider(
                      height: 1,
                    ),
                  )
                ],
              ),
            ),
            Container(
              color: Colors.white,
              padding: EdgeInsets.only(left: 20, right: 12),
              child: UserMessageShow(
                logic.managers,
                title: '部门负责人',
                onCheck: logic.selectDepartmentManager,
                nameKey: 'userName',
                titleFontSize: 16,
              ),
            ),
            SizedBox(
              height: 60,
            ),
            Visibility(
              visible: !logic.isCreate && !logic.onlyShow,
              child: ButtonDelete(title: '删除部门', onTap: logic.deleteDepartment),
            ),
          ],
        );
      }),
    );
  }
}
