import 'package:account_center/common/res/colors.dart';
import 'package:account_center/common/res/text_style.dart';
import 'package:account_center/common/utils/image_load.dart';
import 'package:account_center/page/account_company/company_auth/widget/common/gesture_tap.dart';
import 'package:account_center/style/style_widget.dart';
import 'package:account_center/style/widget/edit_app_bar.dart';
import 'package:account_center/widget/search_bar.dart' as search_bar;
import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

import 'change_department_logic.dart';

class ChangeDepartmentPage extends StatelessWidget {
  final logic = Get.find<ChangeDepartmentLogic>();

  ChangeDepartmentPage({super.key});

  @override
  Widget build(BuildContext context) {
    return MyScaffold(
      appBar: EditAppBar(
        title: '选择人员',
        confirmText: '下一步',
        confirm: () {
          logic.next();
        },
        showCancel: false,
      ),
      body: _bodyContent(),
    );
  }

  Widget _bodyContent() {
    return GetBuilder<ChangeDepartmentLogic>(builder: (logic) {
      return Column(
        children: [
          search_bar.MySearchBar(
            backgroundColor: Colors.white,
            hintText: '搜索',
            onSearchClick: logic.search,
            onChange: logic.searchKeyChange,
          ),
          vGap10,
          Expanded(
            child: ListView.builder(
              itemBuilder: (context, index) {
                return mackItem(logic.showData[index]);
              },
              itemCount: logic.showData.length,
            ),
          ),
        ],
      );
    });
  }

  Widget mackItem(staff) {
    return GetBuilder<ChangeDepartmentLogic>(builder: (logic) {
      return GestureTapWidget(
        onTap: () {
          logic.itemTap(staff, staff['isChecked'] != true);
        },
        child: Column(
          children: [
            Container(
              color: Colors.white,
              padding: EdgeInsets.symmetric(horizontal: 15),
              child: Column(
                children: [
                  vGap15,
                  Row(
                    children: [
                      SizedBox(
                        height: 42,
                        width: 42,
                        child: ImageLoad.user(staff['headImg'],
                            fit: BoxFit.cover,
                            type: ImageTransformerType.circle),
                      ),
                      hGap15,
                      Expanded(
                        child: Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: [
                            Text(
                              staff['userName'] ?? '',
                              style: RTextStyle.mainContentStyle,
                            ),
                            vGap4,
                            Text(
                              staff['userMobile'] ?? '',
                              style: TextStyle(
                                color: RColors.hintColor,
                                fontSize: 12,
                              ),
                            ),
                          ],
                        ),
                      ),
                      StyleWidget.checkBox(
                        staff['isChecked'] == true,
                        (value) {
                          logic.itemTap(staff, value == true);
                        },
                      ),
                    ],
                  ),
                  vGap15,
                  Divider(
                    height: 0.5,
                    color: Color(0xffe1e1e2),
                  )
                ],
              ),
            ),
          ],
        ),
      );
    });
  }
}
