import 'package:account_center/style/widget/button_public_radius.dart';
import 'package:account_center/style/widget/my_app_bar.dart';
import 'package:account_center/widget/form/form_input.dart';
import 'package:account_center/widget/form/form_row.dart';
import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

import 'join_enterprise_logic.dart';

///加入企业  提交申请
class JoinEnterprisePage extends StatelessWidget {
  final logic = Get.find<JoinEnterpriseLogic>();
  final state = Get.find<JoinEnterpriseLogic>().state;

  JoinEnterprisePage({super.key});

  @override
  Widget build(BuildContext context) {
    return MyScaffold(
      appBar: MyAppBar('加入企业'),
      body: _bodyContent(context),
    );
  }

  Widget _bodyContent(context) {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        _headerWidget(state.companyName ?? '', headerUrl: state.companyLogo),
        Padding(
          padding: const EdgeInsets.symmetric(horizontal: 20.0, vertical: 15.0),
          child: Text(
            "申请信息",
            style: TextStyle(fontSize: 16.0, color: Colors.grey),
          ),
        ),
        _itemInput(),
        _itemBottomBtn(context)
      ],
    );
  }

  Widget _headerWidget(String title, {String? headerUrl}) {
    return Container(
      margin: EdgeInsets.only(top: 4),
      padding: EdgeInsets.symmetric(horizontal: 26, vertical: 16),
      color: Colors.white,
      child: Row(
        children: [
          ImageWidget.loadNetImage(
              headerUrl ??
                  'https://img0.baidu.com/it/u=1694074520,2517635995&fm=253&app=138&size=w931&n=0&f=JPEG&fmt=auto?sec=1657472400&t=3b8cee3f0f6a844e69f3b43dff3d8465',
              type: ImageTransformerType.rect,
              width: 42,
              height: 42),
          hGap15,
          Expanded(
              child: Text(
            title,
            maxLines: 1,
            style: TextStyle(
                fontWeight: FontWeight.w600,
                color: Colors.black,
                fontSize: 18,
                overflow: TextOverflow.ellipsis),
          ))
        ],
      ),
    );
  }

  Widget _itemInput() {
    return Expanded(
      child: SingleChildScrollView(
        child: Column(
          children: [
            _formRow('姓名', state.name),
            _formRow('手机号', state.mobile),
            FormInput(
              maxLength: 200,
              title: '备注',
              controller: state.controllerTip,
              focusNode: state.focusNodeTip,
            ),
          ],
        ),
      ),
    );
  }

  Widget _formRow(key, value) {
    return FormRow(
      title: key,
      child: Row(children: [_textWidget(value ?? '')]),
    );
  }

  Widget _textWidget(title) {
    return Text(
      title,
      style: TextStyle(
          color: Color(0xFFA4A8B1), fontSize: 16, fontWeight: FontWeight.w500),
    );
  }

  ///底部按钮
  Widget _itemBottomBtn(context) {
    return Container(
        margin: EdgeInsets.symmetric(horizontal: 15, vertical: 50),
        width: double.infinity,
        child: ButtonPublicRadius(
          onPress: () {
            logic.joinEnterprise();
          },
          text: "提交申请",
        ));
  }
}
