import 'package:account_center/account_center.dart';
import 'package:account_center/api/base_model.dart';

import 'join_enterprise_code_state.dart';

class JoinEnterpriseCodeLogic extends GetxController {
  final JoinEnterpriseCodeState state = JoinEnterpriseCodeState();

  void joinEnterprise() {
    if (state.controller1.text.isEmpty) {
      ToastUtil.showToast('请输入邀请码');
      return;
    }

    _commitRequest();
  }

  void _commitRequest() {
    fetch(Method.get, url: HttpApi.joinEnterpriseCode, onSuccess: (data) {
      if (data != null) {
        Get.offNamed(RouteConfig.joinEnterprisePage, arguments: {
          'contactMobile': data['contactMobile'] ?? '',
          'contactName': data['contactName'] ?? '',
          'companyNo': data['companyNo'] ?? 0,
          'companyLogo': data['companyLogo'],
          'companyName': data['companyName']
        });
      } else {
        ToastUtil.showToast('未获取到信息');
      }
    }, queryParameters: {
      'invitationCode': state.controller1.text
    }); //1261069018415255621
  }
}
