import 'package:account_center/common/utils/image_load.dart';
import 'package:account_center/widget/form/form_row.dart';
import 'package:flutter/material.dart';

abstract class EnterpriseInfoWidget {
  static Widget formRow(key, value) {
    return FormRow(
      title: key,
      crossAxisAlignment: CrossAxisAlignment.start,
      child: Row(children: [
        Expanded(
            child:
                textWidget(value?.toString().isNotEmpty == true ? value : '-'))
      ]),
    );
  }

  static Widget textWidget(title) {
    return Text(
      title,
      style: TextStyle(
        color: Color(0xFF344254),
        fontSize: 16,
        fontWeight: FontWeight.w500,
      ),
    );
  }

  static Widget idImage(String? url) {
    return url?.isNotEmpty == true
        ? ImageLoad.idCard(url)
        : EnterpriseInfoWidget.textWidget('-');
  }
}
