import 'package:account_center/api/base_model.dart';
import 'package:account_center/common/sp/sp_util.dart';
import 'package:account_center/page/account_center/account_center_logic.dart';
import 'package:account_center/page/account_company/company_home/company_manage_logic.dart';
import 'package:account_center/routes/route_config.dart';
import 'package:account_center/widget/select_image_utils.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

import 'enterprise_header_and_name_state.dart';

class EnterpriseHeaderAndNameLogic extends GetxController {
  final EnterpriseHeaderAndNameState state = EnterpriseHeaderAndNameState();

  @override
  void onInit() {
    super.onInit();
    state.companyShortNameInitials =
        Get.arguments['companyShortNameInitials'] ?? '';
    state.companyShortName = Get.arguments['companyShortName'] ?? '';
    state.logoUrl = Get.arguments['companyLogo'] ?? '';
  }

  void cameraCapture() {
    selectPicType(onSuccess: (data) {
      _uploadEnterpriseLogo(data);
    });
  }

  void _uploadEnterpriseLogo(String url) {
    fetch(Method.post,
        url: HttpApi.upLoadCompanyLogo,
        params: {'companyNo': getCompanyNo(), 'logoUrl': url},
        onSuccess: (data) {
      EasyLoading.dismiss();
      state.logoUrl = url;
      Get.find<AccountCenterLogic>().listController.callRefresh();
      Get.find<CompanyManageLogic>().getCompanyUserByNo();
      update();
    });
  }

  void goToUpdatePage(title, shortName, shortNameInitials) {
    Get.toNamed(RouteConfig.updateCompanyShortNameInfoPage, arguments: {
      'title': title,
      'shortName': shortName,
      'shortNameInitials': shortNameInitials
    })?.then((value) {
      if (value != null) {
        state.companyShortName = value?['shortName'] ?? '';
        state.companyShortNameInitials = value['shortNameInitials'] ?? '';
        update();
      }
    });
  }
}
