import 'package:account_center/widget/select_image_utils.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

import 'enterprise_basic_info_state.dart';

class EnterpriseBasicInfoLogic extends GetxController {
  final EnterpriseBasicInfoState state = EnterpriseBasicInfoState();

  var startTimeController = TextEditingController();

  var endTimeController = TextEditingController();

  @override
  void onInit() {
    super.onInit();
    var data = Get.arguments['basicInfo'];
    if (data != null) {
      state.radioIndex = data['applyType'] ?? data['companyType'] ?? 0;
      state.controllerCompanyName.text = data['companyName'] ?? '';
      state.controllerCreditCode.text = data['companyGroupCode'] ?? '';
      state.controllerBankNum.text = data['bankPublicNumber'] ?? '';
      state.controllerBankName.text = data['bankName'] ?? '';
      state.controllerCompanyAddress.text = data['companyAddress'] ?? '';
      state.companyBusinessImg = data['companyBusinessImg'] ?? '';
      startTimeController.text = data['businessStartDate'] ?? '';
      if (data['businessLongTermFlag'] == 1) {
        endTimeController.text = '长期';
      } else {
        endTimeController.text = data['businessEndDate'] ?? '';
      }
      state.businessExpiredFlag = data['businessExpiredFlag'] ?? 0;
    }
  }

  void completed() {
    if (state.radioIndex == 0) {
      ToastUtil.showToast('请选择申请类型');
      return;
    }
    if (state.controllerCompanyName.text.isEmpty) {
      ToastUtil.showToast('请填写公司名称');
      return;
    }
    if (state.radioIndex == 2 && state.companyBusinessImg.isEmpty) {
      ToastUtil.showToast('请上传营业执照');
      return;
    }
    if (state.radioIndex == 2 && startTimeController.text.isEmpty) {
      ToastUtil.showToast('请选择正确的营业期限');
      return;
    }
    if (state.radioIndex == 2 && endTimeController.text.isEmpty) {
      ToastUtil.showToast('请选择正确的营业期限');
      return;
    }
    var endTime = endTimeController.text;
    if (state.radioIndex == 2 && endTime != '长期') {
      if (DateTime.parse(endTime.replaceAll('/', '-')).isBefore(
          DateTime.parse(startTimeController.text.replaceAll('/', '-')))) {
        return ToastUtil.showToast('请选择正确的营业期限');
      }
    }
    /* if (state.controllerCreditCode.text.isEmpty) {
      ToastUtil.showToast('请填写统一社会信用代码');
      return;
    }
    if (state.controllerBankNum.text.isEmpty) {
      ToastUtil.showToast('请填写银行对公账号');
      return;
    }
    if (state.controllerBankName.text.isEmpty) {
      ToastUtil.showToast('请填写银行名称');
      return;
    }
    if (state.controllerCompanyAddress.text.isEmpty) {
      ToastUtil.showToast('请填写公司地址');
      return;
    }
    if (state.companyBusinessImg.isNullOrEmpty()) {
      ToastUtil.showToast('请上传营业执照');
      return;
    }*/
    backResult();
  }

  void backResult() {
    unFocus();

    Map<String, dynamic> params = {
      'companyName': state.controllerCompanyName.text,
      'companyGroupCode': state.controllerCreditCode.text,
      'bankPublicNumber': state.controllerBankNum.text,
      'bankName': state.controllerBankName.text,
      'companyAddress': state.controllerCompanyAddress.text,
      'companyBusinessImg': state.companyBusinessImg, //营业执照图片本地Path
      'applyType': state.radioIndex,
      // 'businessStartDate': startTimeController.text,
      // 'businessEndDate':
      //     endTimeController.text == '长期' ? '' : endTimeController.text,
      // 'businessLongTermFlag': endTimeController.text == '长期' ? 1 : 0
    }
      ..addIf(
          state.radioIndex == 2, 'businessStartDate', startTimeController.text)
      ..addIf(state.radioIndex == 2, 'businessEndDate',
          endTimeController.text == '长期' ? '' : endTimeController.text)
      ..addIf(state.radioIndex == 2, 'businessLongTermFlag',
          endTimeController.text == '长期' ? 1 : 0);
    Get.back(result: params);
  }

  void unFocus() {
    FocusManager.instance.primaryFocus?.unfocus();
  }

  void cameraCapture() {
    selectPicType(onSuccess: (data) {
      state.companyBusinessImg = data ?? '';
      update();
    });
  }

  void changeRadio(value) {
    state.radioIndex = value;
    update();
  }

  void deleteBusinessImg() {
    state.companyBusinessImg = '';
    update();
  }
}
