import 'package:account_center/style/widget/edit_app_bar.dart';
import 'package:account_center/widget/search_bar.dart' as search_bar;
import 'package:account_center/widget/tree_node/tree_list.dart';
import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

import 'department_select_logic.dart';

class DepartmentSelectPage extends StatelessWidget {
  final logic = Get.find<DepartmentSelectLogic>();

  DepartmentSelectPage({super.key});

  @override
  Widget build(BuildContext context) {
    return MyScaffold(
      appBar: EditAppBar(
        title: '选择部门',
        confirm: () => logic.confirm(),
        showCancel: false,
      ),
      body: GetBuilder<DepartmentSelectLogic>(
        builder: (s) {
          return Column(
            children: [
              search_bar.MySearchBar(
                backgroundColor: Colors.white,
                onChange: logic.setKey,
                hintText: '请输入部门名称',
                onSearchClick: (value) => logic.search(),
              ),
              Expanded(
                  child: TreeListWidget(
                logic.nodes,
                keyWork: logic.key,
                selectType: logic.isSingle
                    ? TreeSelectType.single
                    : TreeSelectType.none,
              ))
            ],
          );
        },
      ),
    );
  }
}
