import 'package:account_center/api/base_model.dart';
import 'package:account_center/common/utils/progress_loading.dart';
import 'package:account_center/page/enterprise/certification/signature/signature_status.dart';
import 'package:account_center/page/web/custom_webview.dart';
import 'package:account_center/widget/confirm_dialog.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

class SignatureLogic extends GetxController {
  SignatureStatus? certificationStatus;

  String createTime = '';
  String limitTime = '';
  String sealName = '';
  String sealUrl = '';
  @override
  void onInit() {
    _requestSignatureData();
    super.onInit();
  }

  void _requestSignatureData() {
    fetch(Method.get, url: HttpApi.getLoginEsignCompanySealAndStatus,
        onSuccess: (response) {
      var status = response['sealShowStatus'];
      switch (status) {
        case 0:
          certificationStatus = SignatureStatus.first;
          break;
        case 1:
          certificationStatus = SignatureStatus.doing;
          break;
        case 2:
          certificationStatus = SignatureStatus.outTime;
          break;
        case 3:
          certificationStatus = SignatureStatus.normal;
          break;
        case 4:
          certificationStatus = SignatureStatus.cancel;
          break;
      }
      createTime = response['createTime'] ?? '';
      limitTime = response['limitTime'] ?? '';
      sealName = response['sealName'] ?? '';
      sealUrl = response['sealUrl'] ?? '';
      update();
    });
  }

  void toCertificationSign() {
    showLoading();
    fetch(Method.post, url: HttpApi.saveEsignCompanySealFlow,
        onSuccess: (response) {
      dismissLoading();
      var url = response['authorizationSignShortUrl'];
      Get.to(CustomWebView(url: url))?.then((value) {
        ConfirmDialog(
          content: '是否完成认证',
          confirmButtonText: '已完成',
          confirm: () {
            _requestSignatureData();
          },
        ).show();
      });
      // WebUtil.launchInBrowser(
      //   url,
      // ).then((value) {
      //   ConfirmDialog(
      //     content: '是否完成认证',
      //     confirmButtonText: '已完成',
      //     confirm: () {
      //       _requestSignatureData();
      //     },
      //   ).show();
      // });
    }, onError: (code, message) {
      dismissLoading();
    });
  }
}
