import 'package:account_center/common/res/text_style.dart';
import 'package:account_center/page/account_company/company_auth/widget/common/gesture_tap.dart';
import 'package:account_center/page/enterprise/certification/certification_status.dart';
import 'package:account_center/page/enterprise/certification/certification_tip/certification_status.dart';
import 'package:account_center/routes/route_config.dart';
import 'package:account_center/style/widget/button_public_radius.dart';
import 'package:account_center/style/widget/button_public_radius_outline.dart';
import 'package:account_center/style/widget/my_app_bar.dart';
import 'package:account_center/widget/asset_image_widget.dart';
import 'package:account_center/widget/form/form_show.dart';
import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

import 'certification_tip_logic.dart';

class CertificationTipPage extends StatelessWidget {
  final logic = Get.find<CertificationTipLogic>();

  CertificationTipPage({super.key});

  @override
  Widget build(BuildContext context) {
    return MyScaffold(
      appBar: MyAppBar("企业签章"),
      body: GetBuilder<CertificationTipLogic>(builder: (logic) {
        switch (logic.certificationStatus) {
          case null:
            return Container();
          case CertificationStatus.first:
            return CertificationStatusWidget(
              image: 'certification_not',
              title: '未认证',
              content: '企业认证将跳转到第三方服务平台，认证前需要确认您的企业信息。',
              buttonText: '去实名认证',
              onClick: () {
                Get.toNamed(RouteConfig.enterpriseMessageCertificationPage);
              },
            );
          case CertificationStatus.doing:
            return CertificationStatusWidget(
              image: 'certification_doing',
              title: '办理中',
              content: '企业认证正在办理中…',
              buttonText: '重新认证',
              onClick: () {
                _showConfirmDialog(isDoing: true);
              },
            );
          case CertificationStatus.outTime:
            return CertificationStatusWidget(
              image: 'certification_doing',
              title: '办理中',
              content: '企业认证正在办理中…',
              buttonText: '重新认证',
              onClick: () {
                Get.toNamed(RouteConfig.enterpriseMessageCertificationPage);
              },
            );
          case CertificationStatus.loseEfficacy:
            return CertificationStatusWidget(
              image: 'certification_doing',
              title: '办理中',
              content: '企业认证正在办理中…',
              buttonText: '重新认证',
              onClick: () {
                Get.toNamed(RouteConfig.enterpriseMessageCertificationPage);
              },
            );
          case CertificationStatus.success:
            return _certificationContent(logic);
        }
      }),
    );
  }

  SingleChildScrollView _certificationContent(CertificationTipLogic logic) {
    return SingleChildScrollView(
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          SizedBox(
            height: 10,
          ),
          GestureTapWidget(
            onTap: logic.toSignature,
            child: Container(
              height: 60,
              padding: EdgeInsets.symmetric(horizontal: 20),
              color: Colors.white,
              child: Row(
                children: [
                  AssetImageWidget(
                    imgFileName: 'signature_ic',
                    width: 20,
                    height: 20,
                  ),
                  SizedBox(
                    width: 16,
                  ),
                  Expanded(
                    child: Text(
                      logic.signatureStatus,
                      style: RTextStyle.editContentStyle,
                    ),
                  ),
                  Icon(
                    Icons.arrow_forward_ios_rounded,
                    color: Color(0xffB4BAC6),
                    size: 14,
                  )
                ],
              ),
            ),
          ),
          SizedBox(
            height: 20,
          ),
          Container(
            margin: EdgeInsets.only(left: 20),
            child: Text(
              '企业信息',
              style: TextStyle(fontSize: 14, color: Color(0xff5B6F80)),
            ),
          ),
          SizedBox(
            height: 10,
          ),
          FormShow(
            title: '企业名称',
            content: logic.data['companyName'],
          ),
          FormShow(title: '统一社会信用代码', content: logic.data['companyGroupCode']),
          SizedBox(
            height: 20,
          ),
          Container(
            margin: EdgeInsets.only(left: 20),
            child: Text(
              '代理人信息',
              style: TextStyle(fontSize: 14, color: Color(0xff5B6F80)),
            ),
          ),
          SizedBox(
            height: 10,
          ),
          FormShow(title: '姓名', content: logic.data['agentName']),
          FormShow(title: '手机号', content: logic.data['agentMobile']),
          FormShow(title: '身份证号', content: logic.data['agentCardNo']),
          SizedBox(
            height: 20,
          ),
          Container(
            margin: EdgeInsets.only(left: 20),
            child: Text(
              '法人信息',
              style: TextStyle(fontSize: 14, color: Color(0xff5B6F80)),
            ),
          ),
          SizedBox(
            height: 10,
          ),
          FormShow(title: '姓名', content: logic.data['legalName']),
          FormShow(title: '手机号', content: logic.data['legalMobile']),
          FormShow(title: '身份证号', content: logic.data['legalCardNo']),
        ],
      ),
    );
  }

  void _showConfirmDialog({bool isDoing = false}) {
    Get.dialog(Dialog(
      child: Container(
        padding: EdgeInsets.symmetric(horizontal: 30),
        decoration: BoxDecoration(
            color: Colors.white, borderRadius: BorderRadius.circular(10)),
        child: Column(
          mainAxisSize: MainAxisSize.min,
          children: [
            SizedBox(
              height: 30,
            ),
            Container(
              padding: EdgeInsets.all(5),
              child: Text(
                '您好！根据《中华人民共和国网络安全法》和其他相关法律、法规的规定，办理企业认证需要国家指定机构授权。如确认办理，将跳转到第三方平台进行授权。请在认证前确认您的企业信息！',
                style: TextStyle(color: Color(0xff909399), fontSize: 15),
              ),
            ),
            SizedBox(
              height: 25,
            ),
            Row(
              children: [
                Expanded(
                  child: ButtonPublicRadiusOutline(
                    text: '取消认证',
                    onPress: () {
                      Get.back();
                    },
                    margin: EdgeInsets.all(0),
                  ),
                ),
                SizedBox(
                  width: 15,
                ),
                Expanded(
                  child: ButtonPublicRadius(
                    text: '立即确认',
                    onPress: () {
                      Get.back();
                      if (isDoing) {
                        logic.reContinue();
                      } else {
                        Get.toNamed(
                            RouteConfig.enterpriseMessageCertificationPage);
                      }
                    },
                    margin: EdgeInsets.all(0),
                  ),
                )
              ],
            ),
            SizedBox(
              height: 20,
            )
          ],
        ),
      ),
    ));
  }
}
