import 'package:account_center/api/base_model.dart';
import 'package:account_center/common/sp/sp_key.dart';
import 'package:account_center/routes/route_config.dart';
import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';
import 'package:flutter_clx_base/widget/my_refresh_list_public.dart';

import 'audit_staff_state.dart';

class AuditStaffLogic extends GetxController
    with GetSingleTickerProviderStateMixin {
  final AuditStaffState state = AuditStaffState();

  late TabController controller;
  final MyListController listController = MyListController();

  final TextEditingController reasonController = TextEditingController();

  @override
  void onInit() {
    super.onInit();
    controller = TabController(length: 3, vsync: this);
  }

  ///获取新员工审核列表
  void listLoginUserProductCompany(
      int page, int pageSize, str, SuccessCallback success, error) {
    var authStatus = 10;
    var companyNo = Get.arguments['companyNo'];
    if (str == "待审核") {
      authStatus = 10;
    } else if (str == "已通过") {
      authStatus = 20;
    } else if (str == "已驳回") {
      authStatus = 30;
    }

    var params = {
      "authStatus": authStatus,
      "companyNo": companyNo,
      "page": page,
      "pageSize": pageSize
    };
    fetchList(
      Method.post,
      url: HttpApi.listCompanyUserAuths,
      params: params,
      onSuccess: (response) {
        success(response);
        state.noData[str] = response.isEmpty;
        update();
      },
      onError: (code, message) {
        state.noData[str] = true;
        update();
        success([]);
      },
    );
  }

  //审核员工
  void auditCompanyUserAuth(int authStatus, String? applyNo, {String? reason}) {
    var params = {
      "applyNo": applyNo,
      "authContent": reason,
      "authStatus": authStatus
    };
    fetch(Method.post, url: HttpApi.updateCompanyUserAuth, params: params,
        onSuccess: (data) {
      listController.callRefresh();
      if (authStatus == 20) {
        Get.toNamed(RouteConfig.editPeoplePage, arguments: {
          'userNo': data,
          'companyNo': SpUtil.getString(SPKey.companyNo),
        });
      }
    });
  }

  String getApplyContent(itemData) {
    var content = itemData['applyContent']?.toString();
    var notEmpty = itemData['applyContent']?.toString().isNotEmpty == true;
    return '申请：${notEmpty ? content! : '暂无'}';
  }

  String getShowTime(itemData) {
    var time = itemData.toString();
    if (time.length <= 10) {
      return time;
    } else {
      return time.substring(0, 10);
    }
  }
}
