import 'package:account_center/account_center.dart';
import 'package:account_center/common/sp/sp_key.dart';
import 'package:account_center/common/sp/sp_util.dart';
import 'package:account_center/common/utils/alert_util.dart';
import 'package:account_center/page/account_company/company_auth/widget/common/comapny_http.dart';

import 'widget/stamp_name.dart';

class StampManageLogic extends GetxController {
  List dataSource = [];
  dynamic userInfo;
  bool get isAgentLogic => userInfo?['agentFlag'] ?? true;

  bool get showAdd {
    if ((SpUtil.getString(SPKey.companyName)?.length ?? 0) > 25) {
      return false;
    }
    return dataSource.length < 5;
  }

  @override
  void onInit() {
    super.onInit();

    _requestStampList();
    _getAgentInfo();
  }

  /// 获取代理人信息
  void _getAgentInfo() {
    CompanyHttps.judgeAgentAndAuthStatus(
      getCompanyNo(),
      onSuccess: (data) {
        userInfo = data;
        update();
      },
    );
  }

  /// 获取签章列表
  void _requestStampList() {
    CompanyHttps.listCompanySeal(
      getCompanyNo(),
      onSuccess: (data) {
        dataSource = [data?['sealUrl']];
        update();
      },
    );
  }

  /// 签章使用记录
  void stampUseHistory() {
    Get.toNamed(RouteConfig.stampUseHistory);
  }

  /// 新建签章
  void appleNewStamp() {
    if (!isAgentLogic) {
      AlertUtil.showCenterToast('当前登录账号非代理人，无法进行操作');
      return;
    }
    Get.dialog(StampNameAlert(
      confirmBlock: (value) {
        _addNewStamp(value);
      },
    ));
  }

  /// 新增签章
  void _addNewStamp(String? name) {
    CompanyHttps.saveNewCompanySeal(
      getCompanyNo(),
      name,
      onSuccess: (data) {
        AlertUtil.showCenterToast('签章新增成功');
        _requestStampList();
      },
    );
  }
}
