import 'package:account_center/account_center.dart';
import 'package:account_center/page/account_company/company_auth/widget/common/gesture_tap.dart';
import 'package:account_center/widget/asset_image_widget.dart';
import 'package:flutter/cupertino.dart';

class WarpItem extends StatelessWidget {
  final String logoName;
  final String title;
  final GestureTapCallback tapCallback;

  const WarpItem(
      {super.key,
      required this.title,
      required this.logoName,
      required this.tapCallback});

  @override
  Widget build(BuildContext context) {
    return GestureTapWidget(
      onTap: tapCallback,
      child: Container(
        width: (MediaQuery.of(context).size.width - 20) / 4,
        padding: const EdgeInsets.symmetric(vertical: 20),
        child: Column(
          mainAxisSize: MainAxisSize.min,
          children: [
            AssetImageWidget(
              imgFileName: logoName,
              width: 34,
              height: 34,
            ),
            vGap5,
            Text(
              title,
              style: TextStyle(
                  color: Color(0xff333333),
                  fontSize: 12.0,
                  fontWeight: FontWeight.w400),
            ),
          ],
        ),
      ),
    );
  }
}
