import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';

class CustomLine extends CustomPainter {
  final Color color;
  final double height;
  final double radius;

  const CustomLine(this.color, this.height, this.radius);

  @override
  void paint(Canvas canvas, Size size) {
    final paint = Paint()
      ..color = color
      ..style = PaintingStyle.fill;

    if (radius > 0) {
      final path = Path()
        ..moveTo(0, radius)
        ..quadraticBezierTo(0, 0, radius, 0)
        ..lineTo(size.width - radius, 0)
        ..quadraticBezierTo(size.width, 0, size.width, radius)
        ..lineTo(size.width, size.height - height)
        ..quadraticBezierTo(
            size.width / 2, size.height, 0, size.height - height)
        ..lineTo(0, 0)
        ..close();

      canvas.drawPath(path, paint);
    } else {
      final path = Path()
        ..moveTo(0, 0)
        ..lineTo(size.width, 0)
        ..lineTo(size.width, size.height - height)
        ..quadraticBezierTo(
            size.width / 2, size.height, 0, size.height - height)
        ..lineTo(0, 0)
        ..close();

      canvas.drawPath(path, paint);
    }
  }

  @override
  bool shouldRepaint(covariant CustomPainter oldDelegate) => false;
}
