import 'package:account_center/account_center.dart';
import 'package:account_center/page/account_company/company_auth/widget/common/gesture_tap.dart';
import 'package:flutter/material.dart';

class CompanyManageNav {
  static AppBar createNav(String title,
      {GestureTapCallback? backAction, Widget? action}) {
    return AppBar(
      backgroundColor: Colors.white,
      elevation: 0,
      leading: GestureTapWidget(
        onTap: () {
          if (backAction != null) {
            backAction();
          } else {
            Get.back();
          }
        },
        child: Container(
          color: Colors.white,
          child: Icon(
            Icons.arrow_back_ios_new_rounded,
            color: Color(0xff344254),
            size: 18,
          ),
        ),
      ),
      actions: [if (action != null) action],
      title: Text(title),
      titleTextStyle: TextStyle(
          color: Color(0xff344254), fontSize: 18, fontWeight: FontWeight.w500),
    );
  }

  static AppBar createNoBackNav(String title) {
    return AppBar(
      backgroundColor: Colors.white,
      elevation: 0,
      title: Text(title),
      titleTextStyle: TextStyle(
          color: Color(0xff344254), fontSize: 18, fontWeight: FontWeight.w500),
    );
  }
}
