import 'package:account_center/account_center.dart';
import 'package:account_center/page/account_company/company_auth/widget/common/gesture_tap.dart';
import 'package:account_center/style/style_params.dart';
import 'package:flutter/material.dart';

import '../../company_auth_logic.dart';
import 'business_license_info.dart';
import 'business_license_upload.dart';
import 'legal_person_card.dart';
import 'legal_person_info.dart';

class UploadInfoWidget extends StatelessWidget {
  final CompanyAuthLogic logic;
  const UploadInfoWidget({super.key, required this.logic});

  @override
  Widget build(BuildContext context) {
    return GetBuilder(
        init: logic,
        builder: ((controller) {
          return Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              vGap10,

              /// 营业执照照片
              BusinessLicenseUpload(
                key: logic.companyImgKey,
                url: logic.businessInfoModel?.companyBusinessImg,
                error: logic.businessLicenseError,
                callBack: logic.businessUrlCallBack,
              ),
              vGap10,

              /// 营业执照信息
              BusinessLicenseInfo(
                key: logic.companyInfoKey,
                model: logic.businessInfoModel,
                onChanged: logic.updateBusinessInfo,
                confirmCallBack: logic.updateBusinessValidity,
              ),
              vGap10,

              /// 法人照片
              LegalPersonCard(
                key: logic.legalImgKey,
                onUrl: logic.legalPersonInfoModel?.faceUrl,
                backUrl: logic.legalPersonInfoModel?.backUrl,
                onError: logic.idFaceSideError,
                backError: logic.idBackSideError,
                onCallBack: logic.legalIdCardOnCallBack,
                backCallBack: logic.legalIdCardBackCallBack,
              ),
              vGap10,

              /// 法人信息
              LegalPersonInfo(
                model: logic.legalPersonInfoModel,
                onChanged: logic.updateLegalInfo,
                confirmCallBack: logic.updateLegalValidity,
              ),

              vGap50,

              GestureTapWidget(
                onTap: logic.startEsignVerify,
                child: Container(
                  alignment: Alignment.center,
                  height: 50,
                  margin: EdgeInsets.only(
                    left: 25,
                    right: 25,
                    bottom: MediaQuery.of(context).padding.bottom + 15,
                  ),
                  decoration: BoxDecoration(
                    color: StyleParams.themeColor,
                    borderRadius: BorderRadius.circular(8),
                  ),
                  child: Text(
                    '前往E签宝完成签章授权',
                    style: TextStyle(
                        color: Colors.white,
                        fontSize: 15,
                        fontWeight: FontWeight.w600),
                  ),
                ),
              ),
            ],
          );
        }));
  }
}
