import 'package:account_center/account_center.dart';
import 'package:account_center/common/utils/alert_util.dart';
import 'package:account_center/common/utils/picker_tool.dart';
import 'package:account_center/page/account_company/company_auth/widget/common/gesture_tap.dart';
import 'package:account_center/style/style_params.dart';
import 'package:flutter/material.dart';

import 'company_define.dart';
import 'input_field.dart';

class ValidityAlert extends StatefulWidget {
  final String? startTime;
  final String? endTime;
  final bool isIndefinite;
  final ValidityCallBack? confirmCallBack;

  const ValidityAlert({
    super.key,
    this.startTime,
    this.endTime,
    this.isIndefinite = false,
    this.confirmCallBack,
  });

  @override
  State<StatefulWidget> createState() {
    return _ValidityAlert();
  }
}

class _ValidityAlert extends State<ValidityAlert> {
  bool isIndefinite = false;
  String startTime = '';
  String endTime = '';

  @override
  void initState() {
    super.initState();

    isIndefinite = widget.isIndefinite;
    startTime = widget.startTime ?? '';
    endTime = widget.endTime ?? '';
  }

  @override
  Widget build(BuildContext context) {
    return Container(
      decoration: BoxDecoration(
        borderRadius: BorderRadius.vertical(
          top: Radius.circular(20),
        ),
        color: Colors.white,
      ),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          vGap30,
          Expanded(
            child: Container(
              margin: const EdgeInsets.symmetric(horizontal: 20),
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  InputField(
                    title: '生效时间',
                    placeholder: '请选择生效时间',
                    enabled: false,
                    value: startTime,
                    tapCallback: () {
                      PickerTool.showDatePicker(context,
                          title: '请选择生效时间',
                          dateType: PickerDateType.YMD,
                          maxTime: DateTime.now(),
                          selectTime: startTime.dateTime, onConfirm: (select) {
                        setState(() {
                          startTime = select.toYMD;
                        });
                      });
                    },
                  ),
                  vGap20,
                  InputField(
                    title: '失效时间',
                    placeholder: '请选择失效时间',
                    enabled: false,
                    value: endTime,
                    rightWidget: GestureTapWidget(
                      onTap: () {
                        setState(() {
                          isIndefinite = !isIndefinite;
                        });
                      },
                      child: Row(
                        mainAxisAlignment: MainAxisAlignment.end,
                        crossAxisAlignment: CrossAxisAlignment.center,
                        children: [
                          Icon(
                            isIndefinite
                                ? Icons.check_box_rounded
                                : Icons.check_box_outline_blank_outlined,
                            color: StyleParams.themeColor,
                            size: 17,
                          ),
                          Text(
                            '长期有效',
                            style: TextStyle(
                                color: Color(0xff171A1D),
                                fontSize: 16,
                                fontWeight: FontWeight.w400),
                          ),
                        ],
                      ),
                    ),
                    tapCallback: () {
                      PickerTool.showDatePicker(context,
                          title: '请选择失效时间',
                          dateType: PickerDateType.YMD,
                          minTime: DateTime.now(),
                          selectTime: endTime.dateTime, onConfirm: (select) {
                        setState(() {
                          endTime = select.toYMD;
                        });
                      });
                    },
                  ),
                ],
              ),
            ),
          ),
          Row(
            children: [
              hGap10,
              Expanded(
                child: GestureTapWidget(
                  onTap: () {
                    Get.back();
                  },
                  child: Container(
                    height: 40,
                    decoration: BoxDecoration(
                      borderRadius: BorderRadius.circular(8),
                      color: Colors.white,
                      border:
                          Border.all(color: StyleParams.themeColor, width: 1),
                    ),
                    alignment: Alignment.center,
                    child: Text(
                      '取消',
                      style: TextStyle(
                          color: StyleParams.themeColor,
                          fontSize: 17,
                          fontWeight: FontWeight.w500),
                    ),
                  ),
                ),
              ),
              hGap10,
              Expanded(
                child: GestureTapWidget(
                  onTap: confirmValidity,
                  child: Container(
                    height: 40,
                    decoration: BoxDecoration(
                      borderRadius: BorderRadius.circular(8),
                      color: StyleParams.themeColor,
                    ),
                    alignment: Alignment.center,
                    child: Text(
                      '确定',
                      style: TextStyle(
                          color: Colors.white,
                          fontSize: 17,
                          fontWeight: FontWeight.w500),
                    ),
                  ),
                ),
              ),
              hGap10,
            ],
          ),
          vGap30,
        ],
      ),
    );
  }

  /// 确认按钮点击事件
  void confirmValidity() {
    if (!startTime.isTimeStr) {
      AlertUtil.showCenterToast('请选择生效时间');
      return;
    }
    if (!endTime.isTimeStr && !isIndefinite) {
      AlertUtil.showCenterToast('请选择失效时间');
      return;
    }
    if (!isIndefinite) {
      if (startTime.isAfter(endTime)) {
        AlertUtil.showCenterToast('生效时间不能晚于失效时间');
        return;
      }
    }
    if (widget.confirmCallBack != null) {
      widget.confirmCallBack!(startTime, endTime, isIndefinite);
      Get.back();
    }
  }
}
