import 'package:account_center/account_center.dart';
import 'package:account_center/style/style_params.dart';
import 'package:flutter/material.dart';

enum StepStatus {
  /// 已完成
  finsh,

  /// 进行中
  doing,

  /// 未执行
  wait,
}

enum NodeType {
  /// 开始节点
  star,

  /// 中间节点
  center,

  /// 结束节点
  end,
}

class TopStepItem extends StatelessWidget {
  const TopStepItem(
      {super.key,
      required this.title,
      required this.status,
      this.type = NodeType.center,
      this.mainColor,
      this.defaultColor});

  final StepStatus status;
  final NodeType type;
  final String title;
  final Color? mainColor;
  final Color? defaultColor;

  @override
  Widget build(BuildContext context) {
    return Expanded(
        child: Column(
      mainAxisAlignment: MainAxisAlignment.center,
      children: [
        SizedBox(
          height: 24,
          child: Row(
            children: [
              Visibility(
                visible: type == NodeType.star,
                child: hGap5,
              ),
              Expanded(
                child: Container(
                  height: 1,
                  color: _getLeftColor,
                ),
              ),
              hGap5,
              Container(
                width: _nodeSize,
                height: _nodeSize,
                alignment: Alignment.center,
                decoration: BoxDecoration(
                  borderRadius: BorderRadius.circular(_nodeRadius),
                  border: Border.all(color: _nodeColor),
                ),
                child: status == StepStatus.doing
                    ? Container(
                        width: 12,
                        height: 12,
                        clipBehavior: Clip.hardEdge,
                        decoration: BoxDecoration(
                          borderRadius: BorderRadius.circular(6),
                          color: _lightColor,
                        ),
                      )
                    : null,
              ),
              hGap5,
              Expanded(
                child: Container(
                  height: 1,
                  color: _getRightColor,
                ),
              ),
              Visibility(
                visible: type == NodeType.end,
                child: hGap5,
              )
            ],
          ),
        ),
        Text(
          title,
          style: TextStyle(
              color: _titleColor, fontSize: 13, fontWeight: FontWeight.w600),
        )
      ],
    ));
  }

  /// 节点外圈大小
  double get _nodeSize => status == StepStatus.doing ? 18 : 10;
  double get _nodeRadius => _nodeSize / 2;

  /// 常规颜色
  Color get _normalColor => defaultColor ?? Color(0xffC5C7D3);

  /// 高亮颜色
  Color get _lightColor => mainColor ?? StyleParams.themeColor;

  /// 节点颜色
  Color get _nodeColor =>
      status != StepStatus.wait ? _lightColor : _normalColor;

  /// 节点文案颜色
  Color get _titleColor =>
      status == StepStatus.doing ? _lightColor : Color(0xff344254);

  /// 节点左侧颜色
  Color get _getLeftColor {
    if (type == NodeType.star) {
      return Colors.white.withAlpha(0);
    } else {
      if (status == StepStatus.wait) {
        return _normalColor;
      } else {
        return _lightColor;
      }
    }
  }

  /// 节点右侧颜色
  Color get _getRightColor {
    if (type == NodeType.end) {
      return Colors.white.withAlpha(0);
    } else {
      if (status == StepStatus.finsh) {
        return _lightColor;
      } else {
        return _normalColor;
      }
    }
  }
}
