import 'package:flutter/material.dart';

class GestureTapWidget extends StatelessWidget {
  GestureTapWidget({
    super.key,
    this.behavior,
    this.child,
    this.onTap,
    this.interval = 1,
  });

  final Widget? child;
  final GestureTapCallback? onTap;
  final HitTestBehavior? behavior;

  /// 最后一次事件响应
  DateTime? _tapTime;

  /// 事件响应间隔
  int interval = 1;

  /// 能否点击
  bool get canTap {
    if (_tapTime != null) {
      if (_tapTime!.add(Duration(seconds: interval)).isBefore(DateTime.now())) {
        _tapTime = DateTime.now();
        return true;
      } else {
        return false;
      }
    }
    _tapTime ??= DateTime.now();

    return true;
  }

  @override
  Widget build(BuildContext context) {
    return GestureDetector(
      behavior: behavior,
      onTap: _onTapHookFunc,
      child: child,
    );
  }

  void _onTapHookFunc() {
    if (canTap) {
      if (onTap != null) {
        onTap!();
      }
    }
  }
}
