import 'package:account_center/style/style_params.dart';
import 'package:flutter/material.dart';

/// 有效期回调函数
typedef ValidityCallBack = Function(
    String startTime, String endTime, bool isIndefinite);

/// 图片上传成功后，地址回调
typedef ImageUploadCallBack = Function(String resUrl);

/// 输入框输入回调
typedef InputOnChange = Function(int type, String? value);

/// 单个入参回调
typedef DynamicCallBack = Function(dynamic value);
typedef StringCallBack = Function(String value);

/// 签章使用记录筛选回调
typedef StampScreenBlock = Function(
    dynamic stamp, String? code, String? startTime, String? endTime);

/// 富文本-常规样式
TextStyle get normalStyle => TextStyle(
    color: Color(0xff000000), fontSize: 18, fontWeight: FontWeight.w600);

/// 富文本-高亮样式
TextStyle get lightStyle => TextStyle(
    color: StyleParams.themeColor, fontSize: 18, fontWeight: FontWeight.w600);

enum CompanyAuthFrom {
  none, // 企业已创建，只是进行认证
  newCompany, // 创建企业，进行认证
  update, // 重新认证
}

enum AuthAndSignStatus {
  normal, // 空白页
  authSucc, // 企业认证成功
  authFail, // 企业认证失败
  signing, // 企业签章授权中
  signSucc, // 企业签章授权成功
  signFail, // 企业签章授权失败
}
