import 'package:account_center/api/api_config.dart';
import 'package:account_center/api/base_model.dart';
import 'package:account_center/common/net/base_dio_utils.dart';

class CompanyHttps {
  /// 获取企业信息
  static getCompanyInfo(
    String? companyNo, {
    NetSuccessCallback? onSuccess,
    NetErrorCallback? onError,
  }) {
    var queryParameters = {
      'companyNo': companyNo,
    };
    fetch(Method.get,
        url: HttpApi.getCompanyDetailByNo,
        queryParameters: queryParameters,
        onSuccess: onSuccess,
        onError: onError);
  }

  /// 识别用户身份信息
  static getLegalPersonIdCardOcrInfo(
    String? companyNo,
    String? legalIdCardFaceImage,
    String? legalIdCardBackImage, {
    NetSuccessCallback? onSuccess,
    NetErrorCallback? onError,
  }) {
    Map<String, dynamic> params = {
      'companyNo': companyNo,
      'legalIdCardBackImage': legalIdCardBackImage,
      'legalIdCardFaceImage': legalIdCardFaceImage,
    };
    fetch(Method.get,
        url: '/msl-user/app/company/realName/getLegalPersonIdCardOcrInfo',
        queryParameters: params,
        onSuccess: onSuccess,
        onError: onError);
  }

  /// 企业实名认证短信验证码
  static sendCompanyRealNameCaptcha(
    String? mobile,
    String? companyNo, {
    NetSuccessCallback? onSuccess,
    NetErrorCallback? onError,
  }) {
    fetch(
      Method.get,
      url: '/msl-user/captchaSms/sendCompanyRealNameCaptcha',
      queryParameters: {'mobile': mobile, 'companyNo': companyNo},
      onSuccess: onSuccess,
      onError: onError,
    );
  }

  /// 企业签名授权验证码
  static sendCompanySealAuthorizationCaptcha(
    String? mobile,
    String? companyNo, {
    NetSuccessCallback? onSuccess,
    NetErrorCallback? onError,
  }) {
    fetch(
      Method.get,
      url: '/msl-user/captchaSms/sendCompanySealAuthorizationCaptcha',
      queryParameters: {'mobile': mobile, 'companyNo': companyNo},
      onSuccess: onSuccess,
      onError: onError,
    );
  }

  /// 识别营业执照图片
  static getBusinessLicenseOcrInfo(
    String? businessLicenseImage,
    String? companyNo, {
    NetSuccessCallback? onSuccess,
    NetErrorCallback? onError,
  }) {
    Map<String, dynamic> parmas = {
      'businessLicenseImage': businessLicenseImage,
      'companyNo': companyNo,
    };
    fetch(Method.get,
        url: '/msl-user/app/company/realName/getBusinessLicenseOcrInfo',
        queryParameters: parmas,
        onSuccess: onSuccess,
        onError: onError);
  }

  /// 确认企业认证信息
  static confirmCompanyRealNameInfo(
    Map<String, dynamic>? businessLicenseInfoVo,
    Map<String, dynamic>? legalIdCardInfoVo,
    String? companyNo, {
    NetSuccessCallback? onSuccess,
    NetErrorCallback? onError,
  }) {
    fetch(Method.post,
        url: '/msl-user/app/company/realName/confirmCompanyRealNameInfo',
        params: {
          'businessLicenseInfoVo': businessLicenseInfoVo,
          'legalIdCardInfoVo': legalIdCardInfoVo,
          'companyNo': companyNo,
        },
        onSuccess: onSuccess,
        onError: onError);
  }

  /// 查看实名信息
  static getUserRealNameInfo(
    String? userNo, {
    NetSuccessCallback? onSuccess,
    NetErrorCallback? onError,
  }) {
    fetch(Method.get,
        url: '/msl-user/userShow/getUserRealNameInfo',
        queryParameters: {
          'userNo': userNo,
        },
        onSuccess: onSuccess,
        onError: onError);
  }

  /// 发起企业认证流程
  static saveCompanyRealNameFlow(
    String? agentCaptcha,
    String? companyNo, {
    NetSuccessCallback? onSuccess,
    NetErrorCallback? onError,
  }) {
    fetch(Method.post,
        url: '/msl-user/app/company/realName/saveCompanyRealNameFlow',
        params: {
          'agentCaptcha': agentCaptcha,
          'companyNo': companyNo,
        },
        onSuccess: onSuccess,
        onError: onError);
  }

  /// 查询打款银行支行列表
  static listBankSubbranchList(
    String? bankName,
    String? companyNo, {
    NetSuccessCallback? onSuccess,
    NetErrorCallback? onError,
  }) {
    fetch(Method.get,
        url: '/msl-user/app/company/realName/listBankSubbranchList',
        queryParameters: {
          'bankName': bankName,
          'companyNo': companyNo,
        },
        onSuccess: onSuccess,
        onError: onError);
  }

  /// 发起对公打款
  static savePublicTransferAmount(
    Map<String, dynamic> json, {
    NetSuccessCallback? onSuccess,
    NetErrorCallback? onError,
  }) {
    fetch(Method.post,
        url: '/msl-user/app/company/realName/savePublicTransferAmount',
        params: json,
        onSuccess: onSuccess,
        onError: onError);
  }

  /// 验证企业认证打款金额
  static verifyRealNameTransferAmount(
    String? amount,
    String? companyNo, {
    NetSuccessCallback? onSuccess,
    NetErrorCallback? onError,
  }) {
    fetch(Method.post,
        url: '/msl-user/app/company/realName/verifyRealNameTransferAmount',
        params: {
          "amount": amount,
          "companyNo": companyNo,
        },
        onSuccess: onSuccess,
        onError: onError);
  }

  /// 判断当前操作人是否代理人及认证状态
  static judgeAgentAndAuthStatus(
    String? companyNo, {
    NetSuccessCallback? onSuccess,
    NetErrorCallback? onError,
  }) {
    fetch(
      Method.get,
      url: '/msl-user/app/company/realName/judgeAgentAndAuthStatus',
      queryParameters: {'companyNo': companyNo},
      onSuccess: onSuccess,
      onError: onError,
    );
  }

  /// 企业电子印章授权
  static saveCompanySealAuthorizationFlow(
    String? agentCaptcha,
    String? companyNo, {
    NetSuccessCallback? onSuccess,
    NetErrorCallback? onError,
  }) {
    fetch(Method.post,
        url: '/msl-user/app/company/seal/saveCompanySealAuthorizationFlow',
        params: {
          'agentCaptcha': agentCaptcha,
          'companyNo': companyNo,
          'redirectUrl': eSignRedirectUrl
        },
        onSuccess: onSuccess,
        onError: onError);
  }

  /// 印章列表
  static listCompanySeal(
    String? companyNo, {
    NetSuccessCallback? onSuccess,
    NetErrorCallback? onError,
  }) {
    fetch(Method.get,
        url: '/msl-user/company/getCompanyDetailByNo',
        queryParameters: {
          'companyNo': companyNo,
        },
        onSuccess: onSuccess,
        onError: onError);
  }

  /// 新增印章
  static saveNewCompanySeal(
    String? companyNo,
    String? name, {
    NetSuccessCallback? onSuccess,
    NetErrorCallback? onError,
  }) {
    fetch(
      Method.post,
      url: '/msl-user/app/company/seal/saveNewCompanySeal',
      params: {
        'companyNo': companyNo,
        'name': name,
      },
      onSuccess: onSuccess,
      onError: onError,
    );
  }

  /// 签章授权 查看确认信息
  static getCompanySealAuthorizationConfirmInfo(
    String? companyNo, {
    NetSuccessCallback? onSuccess,
    NetErrorCallback? onError,
  }) {
    fetch(
      Method.get,
      url: '/msl-user/app/company/seal/getCompanySealAuthorizationConfirmInfo',
      queryParameters: {
        'companyNo': companyNo,
      },
      onSuccess: onSuccess,
      onError: onError,
    );
  }

  /// 查看印章授权状态
  static getCompanySealAuthorizationStatus(
    String? companyNo, {
    NetSuccessCallback? onSuccess,
    NetErrorCallback? onError,
  }) {
    fetch(
      Method.get,
      url: '/msl-user/app/company/seal/getCompanySealAuthorizationStatus',
      queryParameters: {'companyNo': companyNo},
      onSuccess: onSuccess,
      onError: onError,
    );
  }

  /// 查询企业认证打款信息
  static getCompanyRealNameTransferBankInfo(
    String? companyNo, {
    NetSuccessCallback? onSuccess,
    NetErrorCallback? onError,
  }) {
    fetch(Method.get,
        url:
            '/msl-user/app/company/realName/getCompanyRealNameTransferBankInfo',
        queryParameters: {
          'companyNo': companyNo,
        },
        onSuccess: onSuccess,
        onError: onError);
  }
}
