import 'package:account_center/account_center.dart';
import 'package:flutter/material.dart';

import '../common/attribute_string.dart';
import '../common/company_define.dart';
import '../common/input_field.dart';

class ConfirmBusinessInfo extends StatelessWidget {
  final String? busniessName;
  final String? busniessCode;
  final String? legalName;
  const ConfirmBusinessInfo({
    super.key,
    this.busniessName,
    this.busniessCode,
    this.legalName,
  });

  @override
  Widget build(BuildContext context) {
    return Container(
      padding: const EdgeInsets.only(left: 20, right: 20, top: 20, bottom: 10),
      color: Colors.white,
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          CLXAttributeString()
              .add('请确认', normalStyle)
              .add('企业', lightStyle)
              .add('信息', normalStyle)
              .richText,
          vGap10,
          InputField(
            title: '企业名称',
            value: busniessName,
            enabled: false,
          ),
          InputField(
            title: '信用代码',
            value: busniessCode,
            enabled: false,
          ),
          InputField(
            title: '法人姓名',
            value: legalName,
            enabled: false,
          )
        ],
      ),
    );
  }
}
