import 'package:account_center/account_center.dart';
import 'package:account_center/page/account_company/company_auth/widget/common/gesture_tap.dart';
import 'package:account_center/style/style_params.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';

import '../../company_auth_logic.dart';
import '../common/attribute_string.dart';
import '../common/company_define.dart';
import '../common/input_field.dart';

class WriteAccountInfo extends StatelessWidget {
  final CompanyAuthLogic logic;
  const WriteAccountInfo({super.key, required this.logic});

  @override
  Widget build(BuildContext context) {
    return GetBuilder(
      init: logic,
      builder: ((controller) {
        return Column(
          children: [
            vGap10,
            Container(
              padding: const EdgeInsets.only(
                  left: 20, right: 20, top: 20, bottom: 10),
              color: Colors.white,
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  if (logic.bankInfoModel.transferStatus == 2)
                    Container(
                      margin: const EdgeInsets.only(bottom: 20),
                      width: double.infinity,
                      decoration: BoxDecoration(
                        borderRadius: BorderRadius.circular(8),
                      ),
                      child: Text(
                        '打款失败，请及时修改打款信息',
                        style: TextStyle(
                          color: Color(0xffff0000),
                          fontSize: 18,
                          fontWeight: FontWeight.w600,
                        ),
                      ),
                    ),
                  CLXAttributeString()
                      .add('请填写企业', normalStyle)
                      .add('对公账户', lightStyle)
                      .add('信息', normalStyle)
                      .richText,
                  vGap10,
                  InputField(
                    title: '开户行支行',
                    placeholder: '请选择开户行支行',
                    value: logic.bankInfoModel.bankName,
                    enabled: false,
                    tapCallback: logic.getSuportBankList,
                  ),
                  InputField(
                    title: '银行卡号',
                    value: logic.bankInfoModel.cardNumber,
                    minLength: 12,
                    maxLength: 25,
                    keyboardType: TextInputType.number,
                    inputFormatters: [
                      FilteringTextInputFormatter.digitsOnly,
                    ],
                    onChanged: logic.updateBankInfo,
                  ),
                ],
              ),
            ),
            vGap50,
            GestureTapWidget(
              onTap: logic.uploadBusinessInfo,
              child: Container(
                alignment: Alignment.center,
                height: 50,
                margin: EdgeInsets.only(
                  left: 25,
                  right: 25,
                  bottom: MediaQuery.of(context).padding.bottom + 15,
                ),
                decoration: BoxDecoration(
                  color: StyleParams.themeColor,
                  borderRadius: BorderRadius.circular(8),
                ),
                child: Text(
                  '确认提交',
                  style: TextStyle(
                      color: Colors.white,
                      fontSize: 15,
                      fontWeight: FontWeight.w600),
                ),
              ),
            ),
          ],
        );
      }),
    );
  }
}
