import 'package:account_center/account_center.dart';
import 'package:account_center/common/sp/sp_util.dart';

import '../common/comapny_http.dart';

class BankListLogic extends GetxController {
  /// 支持的银行列表
  List bankList = [];
  String searchKey = '';

  /// 获取支持列表
  void getSuportBankList(String? keyword) {
    searchKey = keyword ?? '';
    if (searchKey.isEmpty) {
      bankList.clear();
      update();
      return;
    }
    CompanyHttps.listBankSubbranchList(
      searchKey.replaceAll(' ', ''),
      getCompanyNo(),
      onSuccess: (data) {
        bankList = data ?? [];
        update();
      },
      onError: (code, msg) {
        bankList = [];
        update();
      },
    );
  }
}
