import 'package:account_center/account_center.dart';
import 'package:account_center/api/base_model.dart';
import 'package:account_center/common/sp/sp_util.dart';
import 'package:account_center/page/account_center/widget/result_layout.dart';
import 'package:account_center/page/account_center/widget/seal_preview.dart';
import 'package:account_center/style/widget/my_app_bar.dart';
import 'package:flutter/material.dart';

class SealIdentityResult extends StatefulWidget {
  final bool isSuccess;
  final String? failReason;
  const SealIdentityResult({
    super.key,
    required this.isSuccess,
    this.failReason,
  });

  @override
  State<SealIdentityResult> createState() => _SealIdentityState();
}

class _SealIdentityState extends State<SealIdentityResult> {
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      backgroundColor: Colors.white,
      appBar: MyAppBar(
        '授权结果',
      ),
      body: ResultLayout(
        title: widget.isSuccess ? '个人签名授权成功' : '个人签名授权失败',
        icon: widget.isSuccess ? 'circle_success' : 'circle_failed',
        buttonText: widget.isSuccess ? '查看签名' : '重新授权',
        secondTitle: widget.isSuccess ? null : widget.failReason,
        onTap: () {
          if (widget.isSuccess) {
            LoadingUtils.showLoading();
            fetch(Method.get,
                url: HttpApi.getUserDetailInfo,
                queryParameters: {"userNo": getUserNo()},
                onSuccess: (response) {
              LoadingUtils.dismiss();
              Get.dialog(
                Dialog(
                  child: SealPreview(
                    url: response['sealImage'] ?? '',
                    id: response['sealId'] ?? '',
                  ),
                ),
              );
            }, onError: (e, c) {
              LoadingUtils.dismiss();
            });
          } else {
            Get.offNamed(RouteConfig.userSeal);
          }
        },
      ),
    );
  }
}
